/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity.spells;

import alexthw.ars_elemental.registry.ModEntities;
import alexthw.ars_elemental.util.GlyphEffectUtil;
import alexthw.ars_elemental.util.ParticleUtil;
import com.hollingsworth.arsnouveau.api.spell.IFilter;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.entity.EntityLingeringSpell;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntityMagnetSpell
extends EntityLingeringSpell {
    List<Predicate<Entity>> ignored;
    public static final EntityDataAccessor<Float> DURATION_UP = SynchedEntityData.defineId(EntityMagnetSpell.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    LivingEntity tracked;

    public EntityMagnetSpell(EntityType<? extends EntityProjectileSpell> type, Level worldIn) {
        super(type, worldIn);
    }

    public EntityMagnetSpell(Level worldIn) {
        super((EntityType)ModEntities.LINGER_MAGNET.get(), worldIn);
    }

    public static EntityMagnetSpell createMagnet(Level world, LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, Vec3 location) {
        EntityMagnetSpell magnet = new EntityMagnetSpell(world);
        magnet.ignored = EntityMagnetSpell.makeIgnores(shooter, spellContext.getSpell(), spellContext.getCurrentIndex() + 1);
        magnet.setPos(location);
        magnet.setAoe((float)spellStats.getAoeMultiplier());
        magnet.setOwner((Entity)shooter);
        magnet.setExtendedTime(spellStats.getDurationMultiplier());
        magnet.setColor(spellContext.getColors());
        return magnet;
    }

    @NotNull
    public EntityType<?> getType() {
        return (EntityType)ModEntities.LINGER_MAGNET.get();
    }

    public boolean shouldFall() {
        return false;
    }

    public float getAoe() {
        return super.getAoe() / 2.0f;
    }

    public void tickNextPosition() {
        if (this.tracked != null) {
            this.setPos(this.tracked.getX(), this.tracked.getY(), this.tracked.getZ());
        }
    }

    public float getExtendedTime() {
        return ((Float)this.entityData.get(DURATION_UP)).floatValue();
    }

    private void setExtendedTime(double durationMultiplier) {
        this.entityData.set(DURATION_UP, (Object)Float.valueOf((float)durationMultiplier));
    }

    public int getExpirationTime() {
        return 70 + (int)(this.getExtendedTime() * 200.0f);
    }

    public void tick() {
        ++this.age;
        if (this.age > this.getExpirationTime()) {
            this.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (this.level().isClientSide() && this.age > this.getParticleDelay()) {
            this.playParticles();
        }
        if (!this.level().isClientSide() && this.age % 5 == 0) {
            for (Entity entity : this.level().getEntities((Entity)this, new AABB(this.blockPosition()).inflate((double)this.getAoe()))) {
                Vec3 vec3d;
                if (this.testFilters(entity) || (vec3d = new Vec3(this.getX() - entity.getX(), this.getY() - entity.getY(), this.getZ() - entity.getZ())).length() < 1.0) continue;
                entity.setDeltaMovement(entity.getDeltaMovement().add(vec3d.normalize()).scale(0.5));
                entity.hurtMarked = true;
            }
        }
        this.tickNextPosition();
    }

    public void playParticles() {
        ParticleUtil.gravityParticles(this.getOnPos(), this.level, this.random, this.getParticleColor(), Math.round(this.getAoe()), 25, 10);
        com.hollingsworth.arsnouveau.client.particle.ParticleUtil.spawnLight((Level)this.level, (ParticleColor)this.getParticleColor(), (Vec3)this.position().add(0.0, 0.5, 0.0), (int)5);
    }

    public boolean testFilters(Entity entity) {
        return this.ignored.stream().anyMatch(filter -> entity == this.tracked || filter.test(entity));
    }

    public static List<Predicate<Entity>> makeIgnores(LivingEntity shooter, Spell spell, int index) {
        ArrayList<Predicate<Entity>> ignore = new ArrayList<Predicate<Entity>>();
        ignore.add(entity -> entity instanceof EntityLingeringSpell);
        ignore.add(entity -> entity == shooter);
        ignore.add(entity -> entity instanceof FamiliarEntity);
        ignore.add(arg_0 -> ((LivingEntity)shooter).isAlliedTo(arg_0));
        Set<IFilter> filters = GlyphEffectUtil.getFilters(spell.unsafeList(), index);
        if (!filters.isEmpty()) {
            ignore.add(entity -> GlyphEffectUtil.checkIgnoreFilters(entity, filters));
        }
        return ignore;
    }

    public void setTracked(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity;
            this.tracked = livingEntity = (LivingEntity)entity;
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DURATION_UP, (Object)Float.valueOf(0.0f));
    }
}

