/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.blocks.upstream;

import alexthw.ars_elemental.ConfigHandler;
import alexthw.ars_elemental.registry.ModTiles;
import com.hollingsworth.arsnouveau.api.source.ISpecialSourceProvider;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WaterUpstreamTile
extends BlockEntity
implements ITickable {
    public WaterUpstreamTile(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)ModTiles.WATER_UPSTREAM_TILE.get(), pWorldPosition, pBlockState);
    }

    public void tick() {
        ServerLevel serverLevel;
        Level level = this.level;
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).getGameTime() % 2L == 0L) {
            if (serverLevel.getBlockState(this.getBlockPos().above()) == this.getBlockState()) {
                return;
            }
            int power = 1;
            while (serverLevel.getBlockState(this.getBlockPos().below(power)) == this.getBlockState()) {
                ++power;
            }
            List entityList = serverLevel.getEntitiesOfClass(LivingEntity.class, new AABB(this.getBlockPos().getCenter(), this.getBlockPos().above(46 * power).getCenter()).inflate(1.5), e -> !e.isSpectator() && e.isInWater() && !e.isCrouching());
            if (!entityList.isEmpty() && this.requiresSource()) {
                List source = SourceUtil.takeSourceMultiple((BlockPos)this.getBlockPos(), (Level)serverLevel, (int)10, (int)((Integer)ConfigHandler.Common.WATER_ELEVATOR_COST.get()));
                if (source == null || source.isEmpty()) {
                    return;
                }
                if (!source.stream().allMatch(ISpecialSourceProvider::isValid)) {
                    return;
                }
            }
            for (LivingEntity e2 : entityList) {
                Vec3 vec3 = e2.getDeltaMovement();
                e2.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 100));
                double d0 = Math.max(0.4, vec3.y + 0.1);
                e2.setDeltaMovement(vec3.x, d0, vec3.z);
                e2.resetFallDistance();
                for (int i = 0; i < 3; ++i) {
                    this.spawnBubbles((Entity)e2, serverLevel);
                }
                e2.hurtMarked = true;
            }
        }
    }

    private boolean requiresSource() {
        return (Integer)ConfigHandler.Common.WATER_ELEVATOR_COST.get() > 0;
    }

    public void spawnBubbles(Entity e, ServerLevel level) {
        double d0 = e.getX();
        double d1 = e.getY();
        double d2 = e.getZ();
        level.sendParticles((ParticleOptions)ParticleTypes.BUBBLE_COLUMN_UP, d0 + ParticleUtil.inRange((double)-0.5, (double)0.5), d1 + 1.0, d2 + ParticleUtil.inRange((double)-0.5, (double)0.5), 2, 0.0, 0.0, 0.0, 0.5);
    }
}

