/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.blocks.prism;

import alexthw.ars_elemental.common.blocks.prism.AbstractPrismLens;
import alexthw.ars_elemental.common.glyphs.MethodHomingProjectile;
import com.hollingsworth.arsnouveau.common.entity.EntityHomingProjectileSpell;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class HomingPrismLens
extends AbstractPrismLens {
    public HomingPrismLens(Item.Properties properties) {
        super(properties, "homing");
    }

    @Override
    public void shoot(ServerLevel world, BlockPos pos, EntityProjectileSpell spell, Vec3 angle) {
        EntityHomingProjectileSpell newProjectile = new EntityHomingProjectileSpell((Level)world, spell.spellResolver);
        List<Predicate<LivingEntity>> ignore = MethodHomingProjectile.basicIgnores(spell.spellResolver.spellContext.getUnwrappedCaster(), true, spell.spellResolver.spell);
        newProjectile.setIgnored(ignore);
        newProjectile.setColor(spell.getParticleColor());
        newProjectile.pierceLeft = spell.pierceLeft;
        newProjectile.prismRedirect = spell.prismRedirect;
        newProjectile.age = spell.age;
        newProjectile.setPos(spell.getX(), spell.getY(), spell.getZ());
        super.shoot(world, pos, (EntityProjectileSpell)newProjectile, angle);
        world.addFreshEntity((Entity)newProjectile);
        spell.discard();
    }

    @Override
    public boolean canConvert(EntityProjectileSpell spell, Level level, BlockPos pos) {
        return !(spell instanceof EntityHomingProjectileSpell);
    }
}

