/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.blocks;

import alexthw.ars_elemental.api.item.ISchoolFocus;
import alexthw.ars_elemental.common.blocks.ElementalSpellTurretTile;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.common.block.BasicSpellTurret;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class ElementalTurret
extends BasicSpellTurret {
    public final SpellSchool school;

    public ElementalTurret(BlockBehaviour.Properties properties, SpellSchool school) {
        super(properties.noOcclusion().forceSolidOn());
        this.school = school;
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new ElementalSpellTurretTile(pos, state).setSchool(this.school);
    }

    static class TurretSpellResolver
    extends EntitySpellResolver {
        SpellSchool school;

        public TurretSpellResolver(SpellContext context, SpellSchool tile) {
            super(context);
            this.school = tile;
        }

        public boolean hasFocus(ItemStack stack) {
            return this.hasFocus(stack.getItem());
        }

        public boolean hasFocus(Item item) {
            if (item instanceof ISchoolFocus) {
                ISchoolFocus focus = (ISchoolFocus)item;
                return this.school == focus.getSchool();
            }
            if (item == ItemsRegistry.SHAPERS_FOCUS.get()) {
                return this.school == SpellSchools.MANIPULATION;
            }
            return super.hasFocus(item);
        }

        public SpellResolver getNewResolver(SpellContext context) {
            return new TurretSpellResolver(context, this.school);
        }
    }
}

