/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.client.mages;

import alexthw.ars_elemental.common.entity.mages.EntityMageBase;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class MageModel<M extends EntityMageBase>
extends HumanoidModel<M> {
    public MageModel(ModelPart pRoot) {
        super(pRoot, RenderType::entityTranslucent);
    }

    public void setupAnim(@NotNull M entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (((EntityMageBase)entity).currentAnim == 2) {
            this.rightArm.z = 0.0f;
            this.rightArm.x = -5.0f;
            this.leftArm.z = 0.0f;
            this.leftArm.x = 5.0f;
            this.rightArm.xRot = Mth.cos((float)(ageInTicks * 0.6662f)) * 0.25f;
            this.leftArm.xRot = Mth.cos((float)(ageInTicks * 0.6662f)) * 0.25f;
            this.rightArm.zRot = 2.3561945f;
            this.leftArm.zRot = -2.3561945f;
            this.rightArm.yRot = 0.0f;
            this.leftArm.yRot = 0.0f;
        } else if (((EntityMageBase)entity).currentAnim == 1) {
            float f3 = ageInTicks / 60.0f;
            this.head.x = Mth.sin((float)(f3 * 10.0f));
            this.head.y = Mth.sin((float)(f3 * 40.0f)) + 0.4f;
            this.rightArm.zRot = (float)Math.PI / 180 * (70.0f + Mth.cos((float)(f3 * 40.0f)) * 10.0f);
            this.leftArm.zRot = this.rightArm.zRot * -1.0f;
            this.rightArm.y = Mth.sin((float)(f3 * 40.0f)) * 0.5f + 1.5f;
            this.leftArm.y = Mth.sin((float)(f3 * 40.0f)) * 0.5f + 1.5f;
            this.body.y = Mth.sin((float)(f3 * 40.0f)) * 0.35f;
        }
    }
}

