/*
 * Decompiled with CFR 0.152.
 */
package fuzs.hoppergadgetry.world.level.block.entity;

import fuzs.hoppergadgetry.init.ModRegistry;
import fuzs.hoppergadgetry.world.level.block.ChuteBlock;
import fuzs.puzzleslib.api.block.v1.entity.TickingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class ChuteBlockEntity
extends HopperBlockEntity
implements TickingBlockEntity {
    public static final Component COMPONENT_CHUTE = Component.translatable((String)"container.chute");

    public ChuteBlockEntity(BlockPos pos, BlockState blockState) {
        super(pos, blockState);
        super.setItems(NonNullList.create());
    }

    public BlockEntityType<?> getType() {
        return (BlockEntityType)ModRegistry.CHUTE_BLOCK_ENTITY_TYPE.value();
    }

    protected Component getDefaultName() {
        return COMPONENT_CHUTE;
    }

    protected NonNullList<ItemStack> getItems() {
        return NonNullList.create();
    }

    protected void setItems(NonNullList<ItemStack> itemStacks) {
    }

    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return null;
    }

    public void serverTick() {
        ChuteBlockEntity.pushItemsTick(this.getLevel(), this.getBlockPos(), this.getBlockState(), this);
    }

    public static void pushItemsTick(Level level, BlockPos blockPos, BlockState blockState, HopperBlockEntity blockEntity) {
        Container container;
        --blockEntity.cooldownTime;
        blockEntity.tickedGameTime = level.getGameTime();
        if (!blockEntity.isOnCooldown() && ChuteBlockEntity.suckInItems(level, (Hopper)blockEntity, container = ChuteBlockEntity.getAttachedContainerWithSpace(level, blockPos, (Direction)blockState.getValue((Property)ChuteBlock.FACING)))) {
            blockEntity.setCooldown(8);
            blockEntity.setChanged();
        }
    }

    public static boolean suckInItems(Level level, Hopper hopper, @Nullable Container container) {
        if (container != null) {
            for (ItemEntity itemEntity : ChuteBlockEntity.getItemsAtAndAbove((Level)level, (Hopper)hopper)) {
                if (!ChuteBlockEntity.addItem((Container)container, (ItemEntity)itemEntity)) continue;
                return true;
            }
        }
        return false;
    }

    public static Container getAttachedContainerWithSpace(Level level, BlockPos blockPos, Direction direction) {
        Container container = ChuteBlockEntity.getContainerAt((Level)level, (BlockPos)blockPos.relative(direction));
        return container != null && !ChuteBlockEntity.isFullContainer((Container)container, (Direction)direction.getOpposite()) ? container : null;
    }

    public boolean canOpen(Player player) {
        return false;
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return false;
    }

    public boolean canTakeItem(Container target, int slot, ItemStack stack) {
        return false;
    }

    public boolean tryLoadLootTable(CompoundTag tag) {
        return true;
    }

    public boolean trySaveLootTable(CompoundTag tag) {
        return true;
    }

    public void unpackLootTable(@Nullable Player player) {
    }

    public static void entityInside(Level level, BlockPos blockPos, BlockState blockState, Entity entity, HopperBlockEntity blockEntity) {
        Container container;
        ItemEntity itemEntity;
        if (entity instanceof ItemEntity && !(itemEntity = (ItemEntity)entity).getItem().isEmpty() && (container = ChuteBlockEntity.getAttachedContainerWithSpace(level, blockPos, (Direction)blockState.getValue((Property)ChuteBlock.FACING))) != null && entity.getBoundingBox().move((double)(-blockPos.getX()), (double)(-blockPos.getY()), (double)(-blockPos.getZ())).intersects(blockEntity.getSuckAabb())) {
            ChuteBlockEntity.addItem((Container)container, (ItemEntity)itemEntity);
        }
    }
}

