/*
 * Decompiled with CFR 0.152.
 */
package fuzs.hoppergadgetry.world.level.block;

import com.mojang.serialization.MapCodec;
import fuzs.hoppergadgetry.init.ModRegistry;
import fuzs.hoppergadgetry.world.level.block.entity.DuctBlockEntity;
import fuzs.puzzleslib.api.block.v1.entity.TickingEntityBlock;
import fuzs.puzzleslib.api.shape.v1.ShapesHelper;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DuctBlock
extends BaseEntityBlock
implements TickingEntityBlock<DuctBlockEntity> {
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = PipeBlock.PROPERTY_BY_DIRECTION;
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final BooleanProperty ENABLED = BlockStateProperties.ENABLED;
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    public static final BooleanProperty UP = BlockStateProperties.UP;
    public static final BooleanProperty DOWN = BlockStateProperties.DOWN;
    public static final MapCodec<DuctBlock> CODEC = DuctBlock.simpleCodec(DuctBlock::new);
    private static final VoxelShape SHAPE = Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    private static final VoxelShape OUTPUT_SHAPE = Block.box((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape INPUT_SHAPE = Block.box((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final Map<Direction, VoxelShape> DIRECTIONAL_OUTPUT_SHAPES = ShapesHelper.rotate((VoxelShape)OUTPUT_SHAPE);
    private static final Map<Direction, VoxelShape> DIRECTIONAL_INPUT_SHAPES = ShapesHelper.rotate((VoxelShape)INPUT_SHAPE);
    private static final VoxelShape[] SHAPES = DuctBlock.makeVoxelShapes();
    private static final Property<?>[] FACING_PROPERTIES = new Property[]{BlockStateProperties.FACING_HOPPER, BlockStateProperties.FACING, BlockStateProperties.HORIZONTAL_FACING};

    public DuctBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.DOWN)).setValue((Property)ENABLED, (Comparable)Boolean.TRUE)).setValue((Property)NORTH, (Comparable)Boolean.FALSE)).setValue((Property)EAST, (Comparable)Boolean.FALSE)).setValue((Property)SOUTH, (Comparable)Boolean.FALSE)).setValue((Property)WEST, (Comparable)Boolean.FALSE)).setValue((Property)UP, (Comparable)Boolean.FALSE)).setValue((Property)DOWN, (Comparable)Boolean.FALSE));
    }

    public MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntityType<? extends DuctBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModRegistry.DUCT_BLOCK_ENTITY_TYPE.value();
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        BlockState blockState = super.updateShape(state, direction, neighborState, level, pos, neighborPos);
        return (BlockState)blockState.setValue((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(this.canConnect(neighborState, direction.getOpposite())));
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        this.checkPoweredState(level, pos, state);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        if (!oldState.is(state.getBlock())) {
            this.checkPoweredState(level, pos, state);
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        Containers.dropContentsOnDestroy((BlockState)state, (BlockState)newState, (Level)level, (BlockPos)pos);
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof HopperBlockEntity) {
            HopperBlockEntity blockEntity2 = (HopperBlockEntity)blockEntity;
            player.openMenu((MenuProvider)blockEntity2);
        }
        return InteractionResult.CONSUME;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)level.getBlockEntity(pos));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape voxelShape = SHAPES[this.getAABBIndex(state)];
        return voxelShape != null ? voxelShape : super.getShape(state, level, pos, context);
    }

    protected int getAABBIndex(BlockState blockState) {
        int index = 0;
        for (Map.Entry<Direction, BooleanProperty> entry : PROPERTY_BY_DIRECTION.entrySet()) {
            if (!((Boolean)blockState.getValue((Property)entry.getValue())).booleanValue()) continue;
            index |= 1 << entry.getKey().get3DDataValue();
        }
        return index |= 1 << ((Direction)blockState.getValue((Property)FACING)).get3DDataValue() + PROPERTY_BY_DIRECTION.size();
    }

    private void checkPoweredState(Level level, BlockPos pos, BlockState state) {
        boolean bl;
        boolean bl2 = bl = !level.hasNeighborSignal(pos);
        if (bl != (Boolean)state.getValue((Property)ENABLED)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)ENABLED, (Comparable)Boolean.valueOf(bl)), 2);
        }
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getClickedFace().getOpposite();
        BlockState blockState = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue((Property)ENABLED, (Comparable)Boolean.TRUE);
        for (Map.Entry<Direction, BooleanProperty> entry : PROPERTY_BY_DIRECTION.entrySet()) {
            BlockState neighborBlockState = context.getLevel().getBlockState(context.getClickedPos().relative(entry.getKey()));
            if (!this.canConnect(neighborBlockState, entry.getKey().getOpposite())) continue;
            blockState = (BlockState)blockState.setValue((Property)entry.getValue(), (Comparable)Boolean.TRUE);
        }
        return blockState;
    }

    private boolean canConnect(BlockState neighborBlockState, Direction direction) {
        if (neighborBlockState.is(ModRegistry.DUCT_INPUTS_BLOCK_TAG)) {
            for (Property<?> property : FACING_PROPERTIES) {
                if (!neighborBlockState.hasProperty(property)) continue;
                return neighborBlockState.getValue(property) == direction;
            }
            return true;
        }
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, ENABLED, NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    private static VoxelShape[] makeVoxelShapes() {
        VoxelShape[] voxelShapes = new VoxelShape[4096];
        voxelShapes[0] = SHAPE;
        block0: for (int i = 0; i < voxelShapes.length; ++i) {
            int x = i >> PROPERTY_BY_DIRECTION.size();
            if (x == 0 || (x & x - 1) != 0) continue;
            for (Direction outputDirection : PROPERTY_BY_DIRECTION.keySet()) {
                if (x != 1 << outputDirection.get3DDataValue()) continue;
                VoxelShape voxelShape = Shapes.or((VoxelShape)SHAPE, (VoxelShape)DIRECTIONAL_OUTPUT_SHAPES.get(outputDirection));
                for (Direction inputDirection : PROPERTY_BY_DIRECTION.keySet()) {
                    if ((i & 1 << inputDirection.get3DDataValue()) == 0) continue;
                    voxelShape = Shapes.or((VoxelShape)voxelShape, (VoxelShape)DIRECTIONAL_INPUT_SHAPES.get(inputDirection));
                }
                voxelShapes[i] = voxelShape;
                continue block0;
            }
        }
        return voxelShapes;
    }
}

