/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.breedablekillerrabbit.forge.events;

import com.natamus.breedablekillerrabbit_common_forge.events.RabbitEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ForgeRabbitEvent {
    @SubscribeEvent
    public static void onBaby(BabyEntitySpawnEvent e) {
        AgeableMob child = e.getChild();
        Level level = child.level();
        if (level.isClientSide) {
            return;
        }
        Mob parentA = e.getParentA();
        Mob parentB = e.getParentB();
        if (!(parentA instanceof Animal) || !(parentB instanceof Animal)) {
            return;
        }
        RabbitEvent.onBaby((ServerLevel)level, (Animal)parentA, (Animal)parentB, e.getChild());
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract e) {
        Level world = e.getLevel();
        if (world.isClientSide) {
            return;
        }
        RabbitEvent.onEntityInteract(e.getEntity(), e.getLevel(), e.getHand(), e.getTarget(), null);
    }

    @SubscribeEvent
    public static void onTarget(LivingAttackEvent e) {
        LivingEntity entity = e.getEntity();
        if (!RabbitEvent.onTarget(entity.level(), (Entity)entity, e.getSource(), e.getAmount())) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void mobSpawn(EntityJoinLevelEvent e) {
        RabbitEvent.mobSpawn(e.getLevel(), e.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerDamage(LivingHurtEvent e) {
        LivingEntity entity = e.getEntity();
        RabbitEvent.onPlayerDamage(entity.level(), (Entity)entity, e.getSource(), e.getAmount());
    }
}

