/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.sgearmetalworks.registry;

import cy.jdkdigital.productivemetalworks.common.block.HotLiquidBlock;
import cy.jdkdigital.productivemetalworks.registry.MetalworksRegistrator;
import cy.jdkdigital.sgearmetalworks.SGearMetalworks;
import cy.jdkdigital.sgearmetalworks.recipe.SilentGearCastingRecipe;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;

public class SGearMetalworksRegistrator {
    public static Map<String, Integer> FLUID_COLORS = new HashMap<String, Integer>();
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> SG_GEAR_CASTING = SGearMetalworks.RECIPE_SERIALIZERS.register("sg_gear_casting", SilentGearCastingRecipe.Serializer::new);
    public static final DeferredHolder<RecipeType<?>, RecipeType<SilentGearCastingRecipe>> SG_GEAR_CASTING_TYPE = SGearMetalworks.RECIPE_TYPES.register("sg_gear_casting", () -> new RecipeType<SilentGearCastingRecipe>(){});
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_CRIMSON_IRON = SGearMetalworksRegistrator.registerFluid("molten_crimson_iron", -1030546);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_CRIMSON_STEEL = SGearMetalworksRegistrator.registerFluid("molten_crimson_steel", -2550725);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_BLAZE_GOLD = SGearMetalworksRegistrator.registerFluid("molten_blaze_gold", -2537720);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_AZURE_SILVER = SGearMetalworksRegistrator.registerFluid("molten_azure_silver", -3170061);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_AZURE_ELECTRUM = SGearMetalworksRegistrator.registerFluid("molten_azure_electrum", -15982115);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_TYRIAN_STEEL = SGearMetalworksRegistrator.registerFluid("molten_tyrian_steel", -5369730);
    public static DeferredHolder<Item, Item> CAST_SWORD = SGearMetalworksRegistrator.registerItem("sword_cast");
    public static DeferredHolder<Item, Item> CAST_KATANA = SGearMetalworksRegistrator.registerItem("katana_cast");
    public static DeferredHolder<Item, Item> CAST_MACHETE = SGearMetalworksRegistrator.registerItem("machete_cast");
    public static DeferredHolder<Item, Item> CAST_SPEAR = SGearMetalworksRegistrator.registerItem("spear_cast");
    public static DeferredHolder<Item, Item> CAST_TRIDENT = SGearMetalworksRegistrator.registerItem("trident_cast");
    public static DeferredHolder<Item, Item> CAST_KNIFE = SGearMetalworksRegistrator.registerItem("knife_cast");
    public static DeferredHolder<Item, Item> CAST_DAGGER = SGearMetalworksRegistrator.registerItem("dagger_cast");
    public static DeferredHolder<Item, Item> CAST_PICKAXE = SGearMetalworksRegistrator.registerItem("pickaxe_cast");
    public static DeferredHolder<Item, Item> CAST_SHOVEL = SGearMetalworksRegistrator.registerItem("shovel_cast");
    public static DeferredHolder<Item, Item> CAST_AXE = SGearMetalworksRegistrator.registerItem("axe_cast");
    public static DeferredHolder<Item, Item> CAST_PAXEL = SGearMetalworksRegistrator.registerItem("paxel_cast");
    public static DeferredHolder<Item, Item> CAST_HAMMER = SGearMetalworksRegistrator.registerItem("hammer_cast");
    public static DeferredHolder<Item, Item> CAST_EXCAVATOR = SGearMetalworksRegistrator.registerItem("excavator_cast");
    public static DeferredHolder<Item, Item> CAST_HOE = SGearMetalworksRegistrator.registerItem("hoe_cast");
    public static DeferredHolder<Item, Item> CAST_MATTOCK = SGearMetalworksRegistrator.registerItem("mattock_cast");
    public static DeferredHolder<Item, Item> CAST_PROSPECTOR_HAMMER = SGearMetalworksRegistrator.registerItem("prospector_hammer_cast");
    public static DeferredHolder<Item, Item> CAST_SAW = SGearMetalworksRegistrator.registerItem("saw_cast");
    public static DeferredHolder<Item, Item> CAST_SICKLE = SGearMetalworksRegistrator.registerItem("sickle_cast");
    public static DeferredHolder<Item, Item> CAST_SHEARS = SGearMetalworksRegistrator.registerItem("shears_cast");
    public static DeferredHolder<Item, Item> CAST_FISHING_ROD = SGearMetalworksRegistrator.registerItem("fishing_rod_cast");
    public static DeferredHolder<Item, Item> CAST_BOW = SGearMetalworksRegistrator.registerItem("bow_cast");
    public static DeferredHolder<Item, Item> CAST_CROSSBOW = SGearMetalworksRegistrator.registerItem("crossbow_cast");
    public static DeferredHolder<Item, Item> CAST_SLINGSHOT = SGearMetalworksRegistrator.registerItem("slingshot_cast");
    public static DeferredHolder<Item, Item> CAST_ARROW = SGearMetalworksRegistrator.registerItem("arrow_cast");
    public static DeferredHolder<Item, Item> CAST_RING = SGearMetalworksRegistrator.registerItem("ring_cast");
    public static DeferredHolder<Item, Item> CAST_BRACELET = SGearMetalworksRegistrator.registerItem("bracelet_cast");
    public static DeferredHolder<Item, Item> CAST_NECKLACE = SGearMetalworksRegistrator.registerItem("necklace_cast");
    public static DeferredHolder<Item, Item> CAST_HELMET = SGearMetalworksRegistrator.registerItem("helmet_cast");
    public static DeferredHolder<Item, Item> CAST_CHESTPLATE = SGearMetalworksRegistrator.registerItem("chestplate_cast");
    public static DeferredHolder<Item, Item> CAST_LEGGINGS = SGearMetalworksRegistrator.registerItem("leggings_cast");
    public static DeferredHolder<Item, Item> CAST_BOOTS = SGearMetalworksRegistrator.registerItem("boots_cast");
    public static DeferredHolder<Item, Item> CAST_SHIELD = SGearMetalworksRegistrator.registerItem("shield_cast");
    public static DeferredHolder<Item, Item> CAST_TOOL_ROD = SGearMetalworksRegistrator.registerItem("tool_rod_cast");
    public static DeferredHolder<Item, Item> CAST_TIP = SGearMetalworksRegistrator.registerItem("tip_cast");

    public static void register() {
    }

    public static DeferredHolder<Item, Item> registerItem(String name) {
        return SGearMetalworksRegistrator.registerItem(name, () -> new Item(new Item.Properties()));
    }

    public static DeferredHolder<Item, Item> registerItem(String name, Supplier<Item> supplier) {
        return SGearMetalworks.ITEMS.register(name, supplier);
    }

    public static DeferredHolder<Block, Block> registerBlock(String name, Supplier<Block> supplier, boolean hasItem) {
        return SGearMetalworksRegistrator.registerBlock(name, supplier, hasItem ? new Item.Properties() : null);
    }

    public static DeferredHolder<Block, Block> registerBlock(String name, Supplier<Block> supplier, Item.Properties properties) {
        DeferredBlock block = SGearMetalworks.BLOCKS.register(name, supplier);
        if (properties != null) {
            SGearMetalworksRegistrator.registerItem(name, () -> new BlockItem((Block)block.get(), properties));
        }
        return block;
    }

    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> registerFluid(String name, int color) {
        FLUID_COLORS.put(name, color);
        DeferredHolder TYPE = SGearMetalworks.FLUID_TYPES.register(name, () -> new FluidType(MetalworksRegistrator.MOLTEN_FLUID_TYPE_PROPERTIES));
        DeferredHolder MOLTEN = SGearMetalworks.FLUIDS.register(name, () -> new BaseFlowingFluid.Source(SGearMetalworksRegistrator.makeMoltenProperties((Supplier<? extends FluidType>)TYPE, name)));
        SGearMetalworks.FLUIDS.register(String.format("flowing_%s", name), () -> new BaseFlowingFluid.Flowing(SGearMetalworksRegistrator.makeMoltenProperties((Supplier<? extends FluidType>)TYPE, name)));
        SGearMetalworksRegistrator.registerItem(String.format("%s_bucket", name), () -> new BucketItem((Fluid)MOLTEN.get(), new Item.Properties().craftRemainder(Items.BUCKET).stacksTo(1)));
        SGearMetalworksRegistrator.registerBlock(name, () -> new HotLiquidBlock((FlowingFluid)MOLTEN.get(), BlockBehaviour.Properties.of().strength(100.0f).speedFactor(0.7f).noCollission().liquid().replaceable()), false);
        return MOLTEN;
    }

    private static BaseFlowingFluid.Properties makeMoltenProperties(Supplier<? extends FluidType> fluidType, String name) {
        return new BaseFlowingFluid.Properties(fluidType, (Supplier)DeferredHolder.create((ResourceKey)Registries.FLUID, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"sgearmetalworks", (String)name)), (Supplier)DeferredHolder.create((ResourceKey)Registries.FLUID, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"sgearmetalworks", (String)String.format("flowing_%s", name)))).bucket((Supplier)DeferredHolder.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"sgearmetalworks", (String)String.format("%s_bucket", name)))).block((Supplier)DeferredHolder.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"sgearmetalworks", (String)name))).tickRate(30).slopeFindDistance(4).levelDecreasePerBlock(2);
    }
}

