/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.sgearmetalworks.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivemetalworks.recipe.ItemCastingRecipe;
import cy.jdkdigital.productivemetalworks.util.FluidHelper;
import cy.jdkdigital.sgearmetalworks.registry.SGearMetalworksRegistrator;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.silentchaos512.gear.crafting.ingredient.PartMaterialIngredient;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.item.CompoundPartItem;

public class SilentGearCastingRecipe
extends ItemCastingRecipe {
    public final PartMaterialIngredient material;
    public final int materialCount;

    public SilentGearCastingRecipe(Ingredient cast, PartMaterialIngredient material, int materialCount, ItemStack result, boolean consumeCast) {
        super(cast, new SizedFluidIngredient(FluidIngredient.of((Fluid[])new Fluid[]{Fluids.WATER}), 1), result, consumeCast);
        this.material = material;
        this.materialCount = materialCount;
    }

    public ItemStack getResultItem(Level level, FluidStack containedFluid) {
        ArrayList<MaterialInstance> mats = new ArrayList<MaterialInstance>();
        Map allowedFluids = FluidHelper.materialsToFluids((Level)level, (Stream)this.material.getItems(), (int)this.materialCount);
        for (Map.Entry entry : allowedFluids.entrySet()) {
            if (!containedFluid.is((Fluid)entry.getKey())) continue;
            ItemStack materialStack = (ItemStack)((Pair)entry.getValue()).getFirst();
            for (int i = 0; i < this.materialCount; ++i) {
                mats.add(MaterialInstance.from((ItemStack)materialStack));
            }
        }
        Item item = this.result.getItem();
        if (item instanceof CompoundPartItem) {
            CompoundPartItem partItem = (CompoundPartItem)item;
            return partItem.create(mats);
        }
        return ItemStack.EMPTY;
    }

    public boolean matches(ItemStack cast, FluidStack fluid, Level level) {
        return this.matches(cast, fluid, false, level);
    }

    public boolean matches(ItemStack cast, FluidStack fluid, boolean matchFluidAmount, Level level) {
        if (!this.cast.test(cast)) {
            return false;
        }
        Map allowedFluids = FluidHelper.materialsToFluids((Level)level, (Stream)this.material.getItems(), (int)this.materialCount);
        for (Fluid entry : allowedFluids.keySet()) {
            if (!fluid.is(entry)) continue;
            return true;
        }
        return false;
    }

    public int getFluidAmount(Level level, FluidStack containedFluid) {
        Map allowedFluids = FluidHelper.materialsToFluids((Level)level, (Stream)this.material.getItems(), (int)this.materialCount);
        if (allowedFluids.containsKey(containedFluid.getFluid())) {
            return (Integer)((Pair)allowedFluids.get(containedFluid.getFluid())).getSecond();
        }
        return containedFluid.getAmount();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)SGearMetalworksRegistrator.SG_GEAR_CASTING.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)SGearMetalworksRegistrator.SG_GEAR_CASTING_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<SilentGearCastingRecipe> {
        private static final MapCodec<SilentGearCastingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC.fieldOf("cast").orElse((Object)Ingredient.EMPTY).forGetter(recipe -> recipe.cast), (App)PartMaterialIngredient.CODEC.fieldOf("material").forGetter(recipe -> recipe.material), (App)Codec.INT.fieldOf("material_count").orElse((Object)1).forGetter(recipe -> recipe.materialCount), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.BOOL.fieldOf("consume_cast").orElse((Object)false).forGetter(recipe -> recipe.consumeCast)).apply((Applicative)builder, SilentGearCastingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SilentGearCastingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<SilentGearCastingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SilentGearCastingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static SilentGearCastingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            return new SilentGearCastingRecipe((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer), (PartMaterialIngredient)PartMaterialIngredient.STREAM_CODEC.decode((Object)buffer), buffer.readInt(), (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer), buffer.readBoolean());
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, SilentGearCastingRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.cast);
            PartMaterialIngredient.STREAM_CODEC.encode((Object)buffer, (Object)recipe.material);
            buffer.writeInt(recipe.materialCount);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            buffer.writeBoolean(recipe.consumeCast);
        }
    }
}

