/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.particle;

import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import pigcart.particlerain.StonecutterUtil;
import pigcart.particlerain.WeatherParticleManager;
import pigcart.particlerain.config.ModConfig;

public abstract class WeatherParticle
extends TextureSheetParticle {
    protected BlockPos.MutableBlockPos pos;
    protected BlockPos.MutableBlockPos oPos;
    boolean doCollisionAnim = false;
    BlockHitResult collision = null;
    float baseTemp;
    float targetOpacity;
    float oQuadSize;
    float distanceSquared;

    protected WeatherParticle(ClientLevel level, double x, double y, double z, float gravity, float opacity, float size, float windStrength, float stormWindStrength) {
        super(level, x, y, z);
        this.gravity = gravity;
        this.quadSize = size;
        this.alpha = 0.0f;
        this.xd = gravity * (level.isThundering() ? stormWindStrength : windStrength);
        if (ModConfig.CONFIG.compat.yLevelWindAdjustment) {
            this.xd *= WeatherParticle.yLevelWindAdjustment(y);
        }
        this.zd = this.xd;
        this.yd = -gravity;
        this.hasPhysics = false;
        this.targetOpacity = opacity;
        this.setSize(0.01f, 0.01f);
        this.lifetime = ModConfig.CONFIG.perf.particleDistance * 100;
        this.pos = new BlockPos.MutableBlockPos(x, y, z);
        this.oPos = new BlockPos.MutableBlockPos(x, y, z);
        this.baseTemp = ((Biome)level.getBiome((BlockPos)this.pos).value()).getBaseTemperature();
        this.testForCollisions();
        ++WeatherParticleManager.particleCount;
    }

    public void tick() {
        super.tick();
        this.oQuadSize = this.quadSize;
        this.distanceSquared = (float)Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().distanceToSqr(this.x, this.y, this.z);
        this.pos.set(this.x, this.y, this.z);
        if (!this.pos.equals((Object)this.oPos)) {
            this.onPositionUpdate();
            this.oPos.set((Vec3i)this.pos);
        }
        if (this.doCollisionAnim) {
            this.collisionAnim();
        }
        this.fadeByDistance();
    }

    public void onPositionUpdate() {
        if (!ModConfig.CONFIG.compat.crossBiomeBorder && (double)Mth.abs((float)(((Biome)this.level.getBiome((BlockPos)this.pos).value()).getBaseTemperature() - this.baseTemp)) > 0.4) {
            this.doCollisionAnim = true;
        }
        if (this.level.getBlockState((BlockPos)this.pos).isCollisionShapeFullBlock((BlockGetter)this.level, (BlockPos)this.pos) || !this.level.getFluidState((BlockPos)this.pos).isEmpty()) {
            this.remove();
        } else {
            this.testForCollisions();
        }
    }

    public void testForCollisions() {
        Vec3 quadCenterPos = new Vec3(this.x, this.y, this.z);
        Vec3 quadEdgePos = new Vec3(this.xd, this.yd, this.zd).normalize().multiply((double)this.quadSize, (double)this.quadSize, (double)this.quadSize).add(this.x, this.y, this.z);
        BlockHitResult hitResult = this.level.clip(StonecutterUtil.getClipContext(quadCenterPos, quadEdgePos));
        if (!hitResult.getType().equals((Object)HitResult.Type.MISS) && !this.doCollisionAnim) {
            this.collision = hitResult;
            this.doCollisionAnim = true;
        }
    }

    public void fadeByDistance() {
        float renderDistanceSquared = Mth.square((int)ModConfig.CONFIG.perf.particleDistance);
        if (this.distanceSquared > renderDistanceSquared + 2.0f) {
            this.remove();
        } else {
            this.alpha = Mth.lerp((float)(this.distanceSquared / renderDistanceSquared), (float)this.targetOpacity, (float)0.0f);
        }
    }

    public float getQuadSize(float scaleFactor) {
        return Mth.lerp((float)scaleFactor, (float)this.oQuadSize, (float)this.quadSize);
    }

    public void collisionAnim() {
        float deltaMovement = (float)new Vec3(this.xd, this.yd, this.zd).length();
        this.quadSize -= deltaMovement;
        if (this.quadSize <= 0.0f) {
            this.remove();
        }
    }

    public void remove() {
        if (this.isAlive()) {
            --WeatherParticleManager.particleCount;
        }
        super.remove();
    }

    public Quaternionf turnBackfaceFlipways(Quaternionf quaternion, Vector3f cameraOffset) {
        Vector3f normal = new Vector3f(0.0f, 0.0f, 1.0f);
        normal.rotate((Quaternionfc)quaternion).normalize();
        float dot = normal.dot((Vector3fc)cameraOffset);
        if (dot > 0.0f) {
            return quaternion.mul((Quaternionfc)Axis.YP.rotation((float)java.lang.Math.PI));
        }
        return quaternion;
    }

    public static double yLevelWindAdjustment(double y) {
        return Math.clamp((double)0.01, (double)0.5, (double)((y - 64.0) / 40.0));
    }

    public ParticleRenderType getRenderType() {
        if (this.targetOpacity == 1.0f) {
            return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
        }
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }
}

