/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import org.joml.AxisAngle4f;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import pigcart.particlerain.config.ModConfig;
import pigcart.particlerain.particle.WeatherParticle;

public class ShrubParticle
extends WeatherParticle {
    protected ShrubParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z, ModConfig.CONFIG.shrub.gravity, ModConfig.CONFIG.shrub.opacity, ModConfig.CONFIG.shrub.size, ModConfig.CONFIG.shrub.windStrength, ModConfig.CONFIG.shrub.stormWindStrength);
        this.hasPhysics = true;
        this.yd = 0.2f;
        BlockState blockState = level.getBlockState(level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, (BlockPos)this.pos));
        if (blockState.is(BlockTags.REPLACEABLE) && !blockState.isAir() && blockState.getFluidState().isEmpty() && !blockState.is(BlockTags.CROPS) && !blockState.is(BlockTags.SNOW)) {
            BakedModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(blockState);
            this.setSprite(model.getParticleIcon());
            BakedQuad quad = (BakedQuad)model.getQuads(blockState, null, this.random).get(0);
            if (quad.isTinted()) {
                Color color = new Color(BiomeColors.getAverageFoliageColor((BlockAndTintGetter)level, (BlockPos)this.pos));
                this.setColor((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
            }
        } else {
            blockState = Blocks.DEAD_BUSH.defaultBlockState();
        }
        this.setSprite(Minecraft.getInstance().getBlockRenderer().getBlockModel(blockState).getParticleIcon());
    }

    @Override
    public void testForCollisions() {
    }

    @Override
    public void tick() {
        super.tick();
        if (this.xd == 0.0 || this.zd == 0.0) {
            this.remove();
        }
        this.xd = this.level.isThundering() ? (double)ModConfig.CONFIG.shrub.stormWindStrength : (double)ModConfig.CONFIG.shrub.windStrength;
        this.zd = this.level.isThundering() ? (double)ModConfig.CONFIG.shrub.stormWindStrength : (double)ModConfig.CONFIG.shrub.windStrength;
        this.oRoll = this.roll;
        this.roll += ModConfig.CONFIG.shrub.rotationAmount;
        if (this.onGround) {
            this.yd = ModConfig.CONFIG.shrub.bounciness;
        }
    }

    @Override
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.TERRAIN_SHEET;
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float tickPercentage) {
        Vector3f camPos = camera.getPosition().toVector3f();
        float x = (float)(Mth.lerp((double)tickPercentage, (double)this.xo, (double)this.x) - (double)camPos.x);
        float y = (float)(Mth.lerp((double)tickPercentage, (double)this.yo, (double)this.y) - (double)camPos.y);
        float z = (float)(Mth.lerp((double)tickPercentage, (double)this.zo, (double)this.z) - (double)camPos.z);
        float angle = (float)Math.atan2((double)this.xd, (double)this.zd);
        Quaternionf quaternion = new Quaternionf();
        quaternion.rotateY(angle);
        Quaternionf quat1 = new Quaternionf(new AxisAngle4f(0.0f, 0.0f, 1.0f, 0.0f));
        Quaternionf quat2 = new Quaternionf(new AxisAngle4f(1.5707964f, 0.0f, 1.0f, 0.0f));
        quat1.mul((Quaternionfc)quaternion).rotateX(Mth.lerp((float)tickPercentage, (float)this.oRoll, (float)this.roll));
        quat2.mul((Quaternionfc)quaternion).rotateZ(Mth.lerp((float)tickPercentage, (float)this.oRoll, (float)this.roll));
        quat1 = this.turnBackfaceFlipways(quat1, new Vector3f(x, y, z));
        quat2 = this.turnBackfaceFlipways(quat2, new Vector3f(x, y, z));
        this.renderRotatedQuad(vertexConsumer, quat1, x, y, z, tickPercentage);
        this.renderRotatedQuad(vertexConsumer, quat2, x, y, z, tickPercentage);
    }

    public static class DefaultFactory
    implements ParticleProvider<SimpleParticleType> {
        public DefaultFactory(SpriteSet provider) {
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new ShrubParticle(level, x, y, z);
        }
    }
}

