/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import org.joml.AxisAngle4d;
import org.joml.AxisAngle4f;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import pigcart.particlerain.ParticleRain;
import pigcart.particlerain.StonecutterUtil;
import pigcart.particlerain.TextureUtil;
import pigcart.particlerain.config.ModConfig;
import pigcart.particlerain.mixin.access.ParticleEngineAccessor;
import pigcart.particlerain.mixin.access.SingleQuadParticleAccessor;
import pigcart.particlerain.particle.WeatherParticle;
import pigcart.particlerain.particle.render.BlendedParticleRenderType;

public class CustomParticle
extends WeatherParticle {
    ModConfig.ParticleOptions opts;

    public CustomParticle(ClientLevel level, double x, double y, double z, ModConfig.ParticleOptions opts) {
        super(level, x, y, z, opts.gravity, opts.opacity, opts.size, opts.windStrength, opts.stormWindStrength);
        this.opts = opts;
        this.lifetime = opts.lifetime;
        ParticleEngineAccessor particleEngine = (ParticleEngineAccessor)Minecraft.getInstance().particleEngine;
        this.setSprite(particleEngine.getTextureAtlas().getSprite(StonecutterUtil.parseResourceLocation(opts.spriteLocations.get(level.random.nextInt(opts.spriteLocations.size())))));
        switch (opts.tintType) {
            case CUSTOM: {
                this.setColor((float)opts.customTint.getRed() / 255.0f, (float)opts.customTint.getGreen() / 255.0f, (float)opts.customTint.getBlue() / 255.0f);
                break;
            }
            case FOG: {
                Color color = new Color(((Biome)this.level.getBiome((BlockPos)this.pos).value()).getFogColor()).darker();
                this.setColor((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
                break;
            }
            case WATER: {
                if (!ModConfig.CONFIG.compat.waterTint) break;
                TextureUtil.applyWaterTint(this, level, (BlockPos)this.pos);
                break;
            }
            case MAP: {
                Color color = StonecutterUtil.getMapColor(level, (BlockPos)this.pos);
                this.setColor((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.opts.constantScreenSize && !this.doCollisionAnim) {
            this.quadSize = this.getDistanceSize();
        }
        this.tickWind();
    }

    public void tickWind() {
        float frequency = ModConfig.CONFIG.wind.gustFrequency;
        float shift = (float)ParticleRain.clientTicks * ModConfig.CONFIG.wind.modulationSpeed;
        float variance = ModConfig.CONFIG.wind.strengthVariance;
        float strength = ModConfig.CONFIG.wind.strength;
        float multiplier = this.level.isThundering() ? this.opts.stormWindStrength : this.opts.windStrength;
        this.xd = (double)((Mth.sin((float)((float)this.x * frequency + shift)) * variance + variance + strength) * multiplier) * CustomParticle.yLevelWindAdjustment(this.y);
        this.zd = (double)((Mth.sin((float)((float)this.z * frequency + shift)) * variance + variance + strength) * multiplier) * CustomParticle.yLevelWindAdjustment(this.y);
    }

    public float getDistanceSize() {
        return this.distanceSquared * (this.opts.size / 100.0f);
    }

    @Override
    public ParticleRenderType getRenderType() {
        return switch (this.opts.renderType) {
            default -> throw new MatchException(null, null);
            case ModConfig.RenderType.TRANSLUCENT -> ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
            case ModConfig.RenderType.OPAQUE -> ParticleRenderType.PARTICLE_SHEET_OPAQUE;
            case ModConfig.RenderType.TERRAIN -> ParticleRenderType.TERRAIN_SHEET;
            case ModConfig.RenderType.BLENDED -> BlendedParticleRenderType.INSTANCE;
        };
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float tickPercent) {
        Vec3 camPos = camera.getPosition();
        float offsetX = (float)(Mth.lerp((double)tickPercent, (double)this.xo, (double)this.x) - camPos.x());
        float offsetY = (float)(Mth.lerp((double)tickPercent, (double)this.yo, (double)this.y) - camPos.y());
        float offsetZ = (float)(Mth.lerp((double)tickPercent, (double)this.zo, (double)this.z) - camPos.z());
        switch (this.opts.rotationType) {
            case COPY_CAMERA: {
                Quaternionf quaternion = new Quaternionf((Quaternionfc)camera.rotation());
                if (this.roll != 0.0f) {
                    quaternion.rotateZ(Mth.lerp((float)tickPercent, (float)this.oRoll, (float)this.roll));
                }
                this.renderRotatedQuad(vertexConsumer, quaternion, offsetX, offsetY, offsetZ, tickPercent);
                break;
            }
            case RELATIVE_VELOCITY: {
                Vector3f camD = Minecraft.getInstance().cameraEntity.getDeltaMovement().toVector3f();
                Vector3f deltaMotion = new Vector3f((float)this.xd - camD.x, (float)this.yd - camD.y, (float)this.zd - camD.z);
                float angle = Math.acos((float)new Vector3f((Vector3fc)deltaMotion).normalize().y);
                Vector3f axis = new Vector3f(-deltaMotion.z(), 0.0f, deltaMotion.x()).normalize();
                Quaternionf quaternion = new Quaternionf(new AxisAngle4f(-angle, (Vector3fc)axis));
                Vector3f transformedOffset = new Vector3f(offsetX, offsetY, offsetZ);
                transformedOffset.rotateAxis(angle, axis.x, axis.y, axis.z);
                quaternion.mul((Quaternionfc)Axis.YP.rotation(Math.atan2((float)transformedOffset.x, (float)transformedOffset.z) + (float)java.lang.Math.PI));
                float speed = Mth.clamp((float)deltaMotion.lengthSquared(), (float)0.2f, (float)1.0f);
                this.turnBackfaceFlipways(quaternion, new Vector3f(offsetX, offsetY, offsetZ));
                this.renderSquishyRotatedQuad(vertexConsumer, quaternion, offsetX, offsetY, offsetZ, tickPercent, speed);
                break;
            }
            case LOOKAT_PLAYER: {
                Vector3f localPos = new Vector3f(offsetX, offsetY, offsetZ);
                Quaternionf quaternion = Axis.YP.rotation((float)java.lang.Math.atan2(offsetX, offsetZ) + (float)java.lang.Math.PI);
                float yAngle = (float)java.lang.Math.asin(offsetY / localPos.length());
                quaternion.rotateX(yAngle);
                quaternion.rotateZ((float)java.lang.Math.atan2(offsetX, offsetZ));
                if (yAngle < -1.0f) {
                    this.doCollisionAnim = true;
                }
                quaternion.rotateZ(Mth.lerp((float)tickPercent, (float)this.oRoll, (float)this.roll));
                this.renderRotatedQuad(vertexConsumer, quaternion, offsetX, offsetY, offsetZ, tickPercent);
                break;
            }
            case FLAT_PLANES: {
                Quaternionf quaternion = new Quaternionf(new AxisAngle4d(1.5707963705062866, -1.0, 0.0, 0.0));
                quaternion.rotateZ(Mth.lerp((float)tickPercent, (float)this.oRoll, (float)this.roll));
                this.turnBackfaceFlipways(quaternion, new Vector3f(offsetX, offsetY, offsetZ));
                this.renderRotatedQuad(vertexConsumer, quaternion, offsetX, offsetY, offsetZ, tickPercent);
            }
        }
    }

    private void renderSquishyRotatedQuad(VertexConsumer vertexConsumer, Quaternionf quaternion, float x, float y, float z, float tickPercent, float squish) {
        float size = this.getQuadSize(tickPercent);
        float u0 = this.getU0();
        float u1 = this.getU1();
        float v0 = this.getV0();
        float v1 = this.getV1();
        int color = this.getLightColor(tickPercent);
        this.renderVertex(vertexConsumer, quaternion, x, y, z, 1.0f, -squish, size, u1, v1, color);
        this.renderVertex(vertexConsumer, quaternion, x, y, z, 1.0f, squish, size, u1, v0, color);
        this.renderVertex(vertexConsumer, quaternion, x, y, z, -1.0f, squish, size, u0, v0, color);
        this.renderVertex(vertexConsumer, quaternion, x, y, z, -1.0f, -squish, size, u0, v1, color);
    }

    private void renderVertex(VertexConsumer buffer, Quaternionf quaternion, float x, float y, float z, float xOffset, float yOffset, float quadSize, float u, float v, int packedLight) {
        SingleQuadParticleAccessor p = (SingleQuadParticleAccessor)((Object)this);
        p.callRenderVertex(buffer, quaternion, x, y, z, xOffset, yOffset, quadSize, u, v, packedLight);
    }

    public static class DefaultFactory
    implements ParticleProvider<SimpleParticleType> {
        ModConfig.ParticleOptions opts;

        public DefaultFactory(ModConfig.ParticleOptions opts) {
            this.opts = opts;
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            for (ModConfig.ParticleOptions options : ModConfig.CONFIG.customParticles) {
                if (!this.opts.id.equals(options.id)) continue;
                this.opts = options;
            }
            return new CustomParticle(level, x, y, z, this.opts);
        }
    }
}

