/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.level.biome.Biome;
import pigcart.particlerain.ParticleRain;

public class ModConfig {
    @NoGUI
    public static final Path CONFIG_FILE = Path.of("config", new String[0]).resolve("particlerain.json");
    @NoGUI
    public static ModConfig CONFIG = new ModConfig();
    @NoGUI
    public static ModConfig DEFAULT = new ModConfig();
    @NoGUI
    public int configVersion = 2;
    @Group
    public PerformanceOptions perf = new PerformanceOptions();
    @Group
    public SoundOptions sound = new SoundOptions();
    @Group
    public WindOptions wind = new WindOptions();
    @Group
    public CompatibilityOptions compat = new CompatibilityOptions();
    @NoGUI
    public List<ParticleOptions> customParticles = new ArrayList<ParticleOptions>(List.of(new ParticleOptions("rain", true, 1.0f, List.of(Biome.Precipitation.RAIN), false, new ArrayList<String>(), true, new ArrayList<String>(), false, 0.9f, 0.5f, 1.0f, 1.0f, 1.5f, false, RenderType.TRANSLUCENT, List.of("particlerain:rain_0", "particlerain:rain_1", "particlerain:rain_2", "particlerain:rain_3"), TintType.WATER, RotationType.RELATIVE_VELOCITY), new ParticleOptions("snow", true, 0.4f, List.of(Biome.Precipitation.SNOW), false, new ArrayList<String>(), true, new ArrayList<String>(), false, 0.05f, 0.1f, 0.2f, 1.0f, 1.5f, false, RenderType.TRANSLUCENT, List.of("particlerain:snow_0", "particlerain:snow_1", "particlerain:snow_2", "particlerain:snow_3"), TintType.NONE, RotationType.COPY_CAMERA), new ParticleOptions("dust", true, 0.8f, List.of(Biome.Precipitation.NONE), false, new ArrayList<String>(), true, List.of("minecraft:camel_sand_step_sound_blocks", "minecraft:sand", "minecraft:terracotta", "c:sandstone_blocks"), false, 0.2f, 2.0f, 3.0f, 1.0f, 1.5f, false, RenderType.TRANSLUCENT, List.of("particlerain:dust"), TintType.MAP, RotationType.COPY_CAMERA), new ParticleOptions("rain_haze", true, 0.1f, List.of(Biome.Precipitation.RAIN), false, new ArrayList<String>(), false, new ArrayList<String>(), false, 0.15f, 0.01f, 0.1f, 0.45f, 3.0f, true, RenderType.TRANSLUCENT, List.of("particlerain:fog_dithered"), TintType.FOG, RotationType.LOOKAT_PLAYER), new ParticleOptions("snow_haze", true, 0.2f, List.of(Biome.Precipitation.SNOW), false, new ArrayList<String>(), false, new ArrayList<String>(), false, 0.05f, 0.01f, 0.1f, 0.45f, 3.0f, true, RenderType.TRANSLUCENT, List.of("particlerain:fog_dithered"), TintType.FOG, RotationType.LOOKAT_PLAYER), new ParticleOptions("dust_haze", true, 0.1f, List.of(Biome.Precipitation.NONE), false, new ArrayList<String>(), true, List.of("minecraft:camel_sand_step_sound_blocks", "minecraft:sand", "minecraft:terracotta", "c:sandstone_blocks"), false, 0.1f, 1.0f, 2.0f, 0.45f, 3.0f, true, RenderType.TRANSLUCENT, List.of("particlerain:fog_dithered"), TintType.MAP, RotationType.LOOKAT_PLAYER), new ParticleOptions("rain_splashing", true, 1.0f, List.of(Biome.Precipitation.RAIN), false, new ArrayList<String>(), false, new ArrayList<String>(List.of("minecraft:lava")), true, 0.0f, 0.0f, 0.0f, 0.45f, 0.25f, false, RenderType.OPAQUE, List.of(), TintType.WATER, RotationType.COPY_CAMERA), new ParticleOptions("rain_ripples", true, 1.0f, List.of(Biome.Precipitation.RAIN), false, new ArrayList<String>(), true, new ArrayList<String>(List.of("minecraft:water")), true, 0.0f, 0.0f, 0.0f, 0.45f, 0.25f, false, RenderType.OPAQUE, List.of(), TintType.WATER, RotationType.COPY_CAMERA), new ParticleOptions("rain_smoke", true, 1.0f, List.of(Biome.Precipitation.RAIN), false, new ArrayList<String>(), true, new ArrayList<String>(List.of("minecraft:strider_warm_blocks", "minecraft:infiniburn_overworld")), true, 0.0f, 0.0f, 0.0f, 0.45f, 0.25f, false, RenderType.OPAQUE, List.of(), TintType.WATER, RotationType.COPY_CAMERA), new ParticleOptions("shrubs", true, 0.002f, List.of(Biome.Precipitation.NONE), false, new ArrayList<String>(), true, List.of("minecraft:camel_sand_step_sound_blocks", "minecraft:sand", "minecraft:terracotta", "c:sandstone_blocks"), true, 0.0f, 0.0f, 0.0f, 0.45f, 0.25f, false, RenderType.OPAQUE, List.of(), TintType.WATER, RotationType.COPY_CAMERA)));
    @NoGUI
    public ShrubOptions shrub = new ShrubOptions();
    @NoGUI
    public RippleOptions ripple = new RippleOptions();
    @NoGUI
    public StreakOptions streak = new StreakOptions();
    @NoGUI
    public MistOptions mist = new MistOptions();
    static final Gson GSON = new GsonBuilder().registerTypeAdapter(Color.class, (Object)new ColorTypeAdapter()).setPrettyPrinting().create();

    public static void loadConfig() {
        File file = CONFIG_FILE.toFile();
        if (file.exists()) {
            try {
                BufferedReader fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
                CONFIG = (ModConfig)GSON.fromJson((Reader)fileReader, ModConfig.class);
            }
            catch (Exception e) {
                ParticleRain.LOGGER.error("Failed to load config - " + e.getMessage());
                CONFIG = DEFAULT;
            }
        }
        if (CONFIG == null || ModConfig.CONFIG.configVersion < ModConfig.DEFAULT.configVersion) {
            CONFIG = DEFAULT;
        }
    }

    public static void saveConfig() {
        File file = CONFIG_FILE.toFile();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            GSON.toJson((Object)CONFIG, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class PerformanceOptions {
        public int maxParticleAmount = 1500;
        public int particleDensity = 100;
        public int particleStormDensity = 200;
        public int particleDistance = 16;
    }

    public static class SoundOptions {
        public boolean doRainSounds = true;
        public boolean doSnowSounds = true;
        public boolean doWindSounds = true;
    }

    public static class WindOptions {
        public float strength = 0.4f;
        public float strengthVariance = 0.3f;
        public float gustFrequency = 0.2f;
        public float modulationSpeed = 0.04f;
    }

    public static class CompatibilityOptions {
        public boolean renderDefaultWeather = false;
        public boolean doDefaultSplashing = false;
        @ReloadsResources
        public boolean waterTint = true;
        @Percentage
        public float tintMix = 0.6f;
        @NoGUI
        public boolean shaderpackTint = true;
        public boolean yLevelWindAdjustment = true;
        public boolean registerParticles = true;
        public boolean crossBiomeBorder = false;
        public boolean useHeightmapTemp = true;
        public boolean canSpawnAboveClouds = true;
    }

    public static class ParticleOptions {
        public String id = "new_particle";
        public boolean enabled = true;
        @Label(key="spawning")
        @Percentage
        public float density = 1.0f;
        public List<Biome.Precipitation> precipitation = List.of(Biome.Precipitation.RAIN);
        @BooleanFormat(t="whitelist", f="blacklist")
        public boolean biomeWhitelist = false;
        public List<String> biomeList = new ArrayList<String>();
        public transient URI biomeTagsWiki = URI.create("https://wiki.fabricmc.net/community:common_tags#biome_tags");
        @BooleanFormat(t="whitelist", f="blacklist")
        public boolean blockWhitelist = false;
        public List<String> blockList = new ArrayList<String>();
        public transient URI blockTagsWiki = URI.create("https://minecraft.wiki/w/Block_tag_(Java_Edition)");
        public boolean onGround = false;
        @Label(key="motion")
        public float gravity = 0.9f;
        public float windStrength = 0.5f;
        public float stormWindStrength = 1.0f;
        public int lifetime = 3000;
        @Label(key="appearance")
        @Percentage
        public float opacity = 0.9f;
        public float size = 0.5f;
        public boolean constantScreenSize = false;
        public RenderType renderType = RenderType.TRANSLUCENT;
        public List<String> spriteLocations = List.of("particlerain:rain_0", "particlerain:rain_1", "particlerain:rain_2", "particlerain:rain_3");
        public TintType tintType = TintType.NONE;
        public Color customTint = Color.BLACK;
        public RotationType rotationType = RotationType.COPY_CAMERA;

        ParticleOptions() {
        }

        ParticleOptions(String id, boolean enabled, float density, List<Biome.Precipitation> precipitation, boolean biomeWhitelist, List<String> biomeList, boolean blockWhitelist, List<String> blockList, boolean onGround, float gravity, float windStrength, float stormWindStrength, float opacity, float size, boolean constantScreenSize, RenderType renderType, List<String> spriteLocations, TintType tintType, RotationType rotationType) {
            this.id = id;
            this.enabled = enabled;
            this.density = density;
            this.precipitation = precipitation;
            this.biomeWhitelist = biomeWhitelist;
            this.biomeList = biomeList;
            this.blockWhitelist = blockWhitelist;
            this.blockList = blockList;
            this.onGround = onGround;
            this.gravity = gravity;
            this.windStrength = windStrength;
            this.stormWindStrength = stormWindStrength;
            this.opacity = opacity;
            this.size = size;
            this.constantScreenSize = constantScreenSize;
            this.renderType = renderType;
            this.spriteLocations = spriteLocations;
            this.tintType = tintType;
            this.rotationType = rotationType;
        }
    }

    public static enum RenderType {
        TERRAIN,
        OPAQUE,
        TRANSLUCENT,
        BLENDED;

    }

    public static enum TintType {
        WATER,
        FOG,
        FOLIAGE,
        MAP,
        CUSTOM,
        NONE;

    }

    public static enum RotationType {
        COPY_CAMERA,
        RELATIVE_VELOCITY,
        LOOKAT_PLAYER,
        FLAT_PLANES;

    }

    @OverrideName(newName="ParticleOptions")
    public static class ShrubOptions {
        @Percentage
        public float density = 0.02f;
        public float gravity = 0.2f;
        public float windStrength = 0.2f;
        public float stormWindStrength = 0.3f;
        @Percentage
        public float opacity = 1.0f;
        public float size = 0.5f;
        public float rotationAmount = 0.2f;
        public float bounciness = 0.2f;
    }

    @OverrideName(newName="ParticleOptions")
    public static class RippleOptions {
        @Percentage
        public float opacity = 0.9f;
        public float size = 0.25f;
        @ReloadsResources
        public int resolution = 16;
        @ReloadsResources
        public boolean useResourcepackResolution = true;
    }

    @OverrideName(newName="ParticleOptions")
    public static class StreakOptions {
        @Percentage
        public float opacity = 0.9f;
        public float size = 0.5f;
    }

    @OverrideName(newName="ParticleOptions")
    public static class MistOptions {
        @Percentage
        public float density = 20.0f;
        public float windStrength = 0.0f;
        public float stormWindStrength = 0.0f;
        @Percentage
        public float opacity = 0.9f;
        public float size = 8.0f;
        public int maxSpawnHeight = 64;
        public int minSpawnHeight = 60;
    }

    public static class ColorTypeAdapter
    implements JsonSerializer<Color>,
    JsonDeserializer<Color> {
        public JsonElement serialize(Color src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)src.getRGB());
        }

        public Color deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new Color(json.getAsInt());
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface NoGUI {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Group {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface BooleanFormat {
        public String t();

        public String f();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Label {
        public String key();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ReloadsResources {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface OverrideName {
        public String newName();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Percentage {
    }
}

