/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import pigcart.particlerain.ParticleRain;
import pigcart.particlerain.StonecutterUtil;
import pigcart.particlerain.config.ModConfig;
import pigcart.particlerain.particle.CustomParticle;

public final class WeatherParticleManager {
    public static int particleCount;
    public static int fogCount;
    private static final BlockPos.MutableBlockPos pos;
    private static final BlockPos.MutableBlockPos heightmapPos;

    private static void spawnParticles(ClientLevel level, Holder<Biome> biome, double x, double y, double z) {
        Biome.Precipitation precipitation = StonecutterUtil.getPrecipitationAt((Level)level, (Biome)biome.value(), (BlockPos)(ModConfig.CONFIG.compat.useHeightmapTemp ? heightmapPos : pos));
        block12: for (ModConfig.ParticleOptions opts : ModConfig.CONFIG.customParticles) {
            if (!opts.enabled || !opts.precipitation.contains(precipitation) || !(opts.density > level.random.nextFloat()) || !WeatherParticleManager.meetsRequirements(opts.biomeList, opts.biomeWhitelist, Registries.BIOME, biome) || !WeatherParticleManager.meetsRequirements(opts.blockList, opts.blockWhitelist, Registries.BLOCK, level.getBlockState((BlockPos)heightmapPos).getBlockHolder())) continue;
            if (opts.onGround) {
                double localBlockX = x - (double)pos.getX();
                double localBlockZ = z - (double)pos.getZ();
                BlockState blockState = level.getBlockState((BlockPos)heightmapPos);
                FluidState fluidState = level.getFluidState((BlockPos)heightmapPos);
                VoxelShape voxelShape = blockState.getCollisionShape((BlockGetter)level, (BlockPos)heightmapPos);
                double blockHeight = voxelShape.max(Direction.Axis.Y, localBlockX, localBlockZ);
                double fluidHeight = fluidState.getHeight((BlockGetter)level, (BlockPos)heightmapPos);
                y = (double)heightmapPos.getY() + Math.max(blockHeight, fluidHeight);
            }
            switch (opts.id) {
                case "rain_splashing": {
                    level.addParticle((ParticleOptions)ParticleTypes.RAIN, x, y, z, 0.0, 0.0, 0.0);
                    continue block12;
                }
                case "rain_ripples": {
                    level.addParticle((ParticleOptions)ParticleRain.RIPPLE, x, y, z, 0.0, 0.0, 0.0);
                    continue block12;
                }
                case "rain_smoke": {
                    level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.0, 0.0);
                    continue block12;
                }
                case "shrubs": {
                    level.addParticle((ParticleOptions)ParticleRain.SHRUB, x, y, z, 0.0, 0.0, 0.0);
                    continue block12;
                }
            }
            Minecraft.getInstance().particleEngine.add((Particle)new CustomParticle(level, x, y, z, opts));
        }
    }

    public static <T> boolean meetsRequirements(List<String> list, boolean isWhitelist, ResourceKey<? extends Registry<T>> registry, Holder<T> holder) {
        if (!list.isEmpty()) {
            for (String string : list) {
                boolean hasMatch;
                ResourceLocation location = StonecutterUtil.parseResourceLocation(string);
                if (location == null) continue;
                TagKey tag = TagKey.create(registry, (ResourceLocation)location);
                boolean bl = hasMatch = holder.is(location) || holder.is(tag);
                if (isWhitelist && hasMatch) {
                    return true;
                }
                if (!hasMatch) continue;
                return false;
            }
            return !isWhitelist;
        }
        return true;
    }

    public static void tick(ClientLevel level, Vec3 cameraPos) {
        if (level.isRaining() && particleCount < ModConfig.CONFIG.perf.maxParticleAmount) {
            int density = (int)((float)Mth.lerpInt((float)level.getThunderLevel(1.0f), (int)ModConfig.CONFIG.perf.particleDensity, (int)ModConfig.CONFIG.perf.particleStormDensity) * level.getRainLevel(1.0f));
            float speed = (float)Minecraft.getInstance().getCameraEntity().getDeltaMovement().lengthSqr();
            density *= (int)(speed * 2.0f + 1.0f);
            for (int i = 0; i < density; ++i) {
                int cloudHeight;
                float height;
                if ((double)speed < 0.8) {
                    height = Mth.abs((float)(Mth.square((float)level.random.nextFloat()) - Mth.square((float)level.random.nextFloat()))) * -1.0f + 1.0f;
                    height *= 1.0f;
                } else {
                    height = level.random.nextFloat();
                }
                float theta = (float)Math.PI * 2 * level.random.nextFloat();
                float phi = (float)Math.acos(2.0f * height - 1.0f);
                float x = (float)ModConfig.CONFIG.perf.particleDistance * Mth.sin((float)phi) * Mth.cos((float)theta) + (float)cameraPos.x;
                float y = (float)ModConfig.CONFIG.perf.particleDistance * Mth.cos((float)phi) + (float)cameraPos.y;
                float z = (float)ModConfig.CONFIG.perf.particleDistance * Mth.sin((float)phi) * Mth.sin((float)theta) + (float)cameraPos.z;
                if (!ModConfig.CONFIG.compat.canSpawnAboveClouds && (cloudHeight = StonecutterUtil.getCloudHeight(level)) != 0 && y > (float)cloudHeight) {
                    y = cloudHeight;
                }
                pos.set((double)x, (double)y, (double)z);
                heightmapPos.set((double)x, (double)(level.getHeight(Heightmap.Types.MOTION_BLOCKING, pos.getX(), pos.getZ()) - 1), (double)z);
                if (heightmapPos.getY() > pos.getY()) continue;
                WeatherParticleManager.spawnParticles(level, (Holder<Biome>)level.getBiome((BlockPos)pos), x, y, z);
            }
        }
    }

    public static SoundEvent getAdditionalWeatherSounds(ClientLevel level, BlockPos blockPos, boolean above) {
        Holder biome = level.getBiome(blockPos);
        Biome.Precipitation precipitation = StonecutterUtil.getPrecipitationAt((Level)level, (Biome)biome.value(), blockPos);
        if (precipitation == Biome.Precipitation.SNOW && ModConfig.CONFIG.sound.doSnowSounds) {
            return above ? ParticleRain.WEATHER_SNOW_ABOVE : ParticleRain.WEATHER_SNOW;
        }
        if (WeatherParticleManager.doesThisBlockHaveDustBlowing(precipitation, level, blockPos, (Holder<Biome>)biome) && ModConfig.CONFIG.sound.doWindSounds) {
            return above ? ParticleRain.WEATHER_SANDSTORM_ABOVE : ParticleRain.WEATHER_SANDSTORM;
        }
        return null;
    }

    public static boolean doesThisBlockHaveDustBlowing(Biome.Precipitation precipitation, ClientLevel level, BlockPos blockPos, Holder<Biome> biome) {
        boolean matchesTag = false;
        List<String> dustyBlockTags = List.of("minecraft:camel_sand_step_sound_blocks", "minecraft:sand");
        for (int i = 0; i < dustyBlockTags.size(); ++i) {
            if (!level.getBlockState(level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockPos).below()).is(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)StonecutterUtil.parseResourceLocation(dustyBlockTags.get(i))))) continue;
            matchesTag = true;
            break;
        }
        return precipitation == Biome.Precipitation.NONE && matchesTag && (double)((Biome)biome.value()).getBaseTemperature() > 0.25;
    }

    public static boolean canHostStreaks(BlockState state) {
        return state.is(BlockTags.IMPERMEABLE) || state.is(BlockTags.MINEABLE_WITH_PICKAXE) || state.is(ParticleRain.GLASS_PANES);
    }

    public static void resetParticleCount() {
        particleCount = 0;
        fogCount = 0;
    }

    static {
        pos = new BlockPos.MutableBlockPos();
        heightmapPos = new BlockPos.MutableBlockPos();
    }
}

