/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain;

import com.mojang.blaze3d.platform.NativeImage;
import it.unimi.dsi.fastutil.ints.IntUnaryOperator;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.nio.IntBuffer;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.biome.Biome;
import org.joml.Math;
import org.lwjgl.system.MemoryUtil;
import pigcart.particlerain.StonecutterUtil;
import pigcart.particlerain.config.ModConfig;
import pigcart.particlerain.mixin.access.NativeImageAccessor;

public class TextureUtil {
    public static IntUnaryOperator desaturateOperation = rgba -> {
        Color col = new Color(rgba, true);
        int gray = Math.max((int)Math.max((int)col.getRed(), (int)col.getGreen()), (int)col.getBlue());
        return (col.getAlpha() & 0xFF) << 24 | (gray & 0xFF) << 16 | (gray & 0xFF) << 8 | gray & 0xFF;
    };

    public static void applyToAllPixels(java.util.function.IntUnaryOperator function, NativeImage image) {
        if (image.format() != NativeImage.Format.RGBA) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "function application only works on RGBA images; have %s", image.format()));
        }
        ((NativeImageAccessor)image).callCheckAllocated();
        int i = image.getWidth() * image.getHeight();
        IntBuffer intBuffer = MemoryUtil.memIntBuffer((long)((NativeImageAccessor)image).getPixels(), (int)i);
        for (int j = 0; j < i; ++j) {
            int k = TextureUtil.argbToABGR(intBuffer.get(j));
            int l = function.applyAsInt(k);
            intBuffer.put(j, TextureUtil.argbToABGR(l));
        }
    }

    public static int argbToABGR(int i) {
        return i & 0xFF00FF00 | (i & 0xFF0000) >> 16 | (i & 0xFF) << 16;
    }

    public static void applyWaterTint(TextureSheetParticle particle, ClientLevel clientLevel, BlockPos blockPos) {
        Color waterColor = new Color(BiomeColors.getAverageWaterColor((BlockAndTintGetter)clientLevel, (BlockPos)blockPos));
        Color fogColor = new Color(((Biome)clientLevel.getBiome(blockPos).value()).getFogColor());
        float rCol = Mth.lerp((float)ModConfig.CONFIG.compat.tintMix, (float)waterColor.getRed(), (float)fogColor.getRed()) / 255.0f;
        float gCol = Mth.lerp((float)ModConfig.CONFIG.compat.tintMix, (float)waterColor.getGreen(), (float)fogColor.getGreen()) / 255.0f;
        float bCol = Mth.lerp((float)ModConfig.CONFIG.compat.tintMix, (float)waterColor.getBlue(), (float)fogColor.getBlue()) / 255.0f;
        particle.setColor(rCol, gCol, bCol);
    }

    public static NativeImage loadTexture(ResourceLocation resourceLocation) throws IOException {
        NativeImage nativeImage;
        Resource resource = Minecraft.getInstance().getResourceManager().getResourceOrThrow(resourceLocation);
        try (InputStream inputStream = resource.open();){
            nativeImage = NativeImage.read((InputStream)inputStream);
        }
        return nativeImage;
    }

    public static SpriteContents splitImage(NativeImage image, int segment, String id) {
        int size = image.getWidth();
        NativeImage sprite = new NativeImage(size, size, false);
        image.copyRect(sprite, 0, size * segment, 0, 0, size, size, true, true);
        return new SpriteContents(StonecutterUtil.getResourceLocation("particlerain", id + segment), new FrameSize(size, size), sprite, StonecutterUtil.getSpriteMetadata());
    }

    public static int getRippleResolution(List<SpriteContents> contents) {
        if (ModConfig.CONFIG.ripple.useResourcepackResolution) {
            ResourceLocation resourceLocation = StonecutterUtil.getResourceLocation("big_smoke_0");
            for (SpriteContents spriteContents : contents) {
                if (!spriteContents.name().equals((Object)resourceLocation)) continue;
                if (spriteContents.width() < 256) {
                    return spriteContents.width();
                }
                return 256;
            }
        }
        if (ModConfig.CONFIG.ripple.resolution < 4) {
            ModConfig.CONFIG.ripple.resolution = 4;
        }
        if (ModConfig.CONFIG.ripple.resolution > 256) {
            ModConfig.CONFIG.ripple.resolution = 256;
        }
        return ModConfig.CONFIG.ripple.resolution;
    }

    public static SpriteContents generateRipple(int i, int size) {
        float radius = (float)size / 2.0f / 8.0f * (float)(i + 1);
        NativeImage image = new NativeImage(size, size, true);
        Color color = Color.WHITE;
        int colorint = (color.getAlpha() & 0xFF) << 24 | (color.getRed() & 0xFF) << 16 | (color.getGreen() & 0xFF) << 8 | color.getBlue() & 0xFF;
        TextureUtil.generateBresenhamCircle(image, size, (int)Math.clamp((float)1.0f, (float)((float)size / 2.0f - 1.0f), (float)radius), colorint);
        return new SpriteContents(StonecutterUtil.getResourceLocation("particlerain", "ripple_" + i), new FrameSize(size, size), image, StonecutterUtil.getSpriteMetadata());
    }

    public static void generateBresenhamCircle(NativeImage image, int imgSize, int radius, int colorint) {
        int centerX = imgSize / 2;
        int centerY = imgSize / 2;
        int x = 0;
        int y = radius;
        int d = 3 - 2 * radius;
        TextureUtil.drawCirclePixel(centerX, centerY, x, y, image, colorint);
        while (y >= x) {
            d = d > 0 ? d + 4 * (x - --y) + 10 : d + 4 * x + 6;
            TextureUtil.drawCirclePixel(centerX, centerY, ++x, y, image, colorint);
        }
    }

    static void drawCirclePixel(int xc, int yc, int x, int y, NativeImage img, int col) {
        img.setPixelRGBA(xc + x, yc + y, col);
        img.setPixelRGBA(xc - x, yc + y, col);
        img.setPixelRGBA(xc + x, yc - y, col);
        img.setPixelRGBA(xc - x, yc - y, col);
        img.setPixelRGBA(xc + y, yc + x, col);
        img.setPixelRGBA(xc - y, yc + x, col);
        img.setPixelRGBA(xc + y, yc - x, col);
        img.setPixelRGBA(xc - y, yc - x, col);
    }
}

