/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain;

import java.awt.Color;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceMetadata;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import pigcart.particlerain.ParticleRain;

public class StonecutterUtil {
    public static Biome.Precipitation getPrecipitationAt(Level level, Biome biome, BlockPos blockPos) {
        return biome.getPrecipitationAt(blockPos);
    }

    public static ResourceLocation getResourceLocation(String namespace, String path) {
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
    }

    public static ResourceLocation getResourceLocation(String path) {
        return ResourceLocation.withDefaultNamespace((String)path);
    }

    public static ResourceLocation parseResourceLocation(String string) {
        try {
            return ResourceLocation.parse((String)string);
        }
        catch (ResourceLocationException e) {
            ParticleRain.LOGGER.error(e.getMessage());
            return null;
        }
    }

    public static ClipContext getClipContext(Vec3 clipStart, Vec3 clipEnd) {
        return new ClipContext(clipStart, clipEnd, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, CollisionContext.empty());
    }

    public static ResourceMetadata getSpriteMetadata() {
        return new ResourceMetadata.Builder().build();
    }

    public static Color getMapColor(ClientLevel level, BlockPos blockPos) {
        Color color = new Color(level.getBlockState(level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockPos).below()).getBlock().defaultMapColor().calculateRGBColor(MapColor.Brightness.NORMAL));
        return new Color(color.getBlue(), color.getGreen(), color.getRed());
    }

    public static int getCloudHeight(ClientLevel level) {
        return (int)level.effects().getCloudHeight();
    }
}

