/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tradingpost.world.inventory;

import fuzs.tradingpost.TradingPost;
import fuzs.tradingpost.config.ServerConfig;
import fuzs.tradingpost.init.ModRegistry;
import fuzs.tradingpost.mixin.accessor.MerchantMenuAccessor;
import fuzs.tradingpost.world.entity.npc.LocalMerchant;
import fuzs.tradingpost.world.entity.npc.MerchantCollection;
import fuzs.tradingpost.world.inventory.TradingPostContainer;
import fuzs.tradingpost.world.level.block.TradingPostBlock;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.MerchantContainer;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.inventory.MerchantResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.block.Block;

public class TradingPostMenu
extends MerchantMenu {
    private final ContainerLevelAccess access;
    private final MerchantCollection traders;
    private final MerchantContainer tradeContainer;
    private int ticks;
    private boolean lockOffers;

    public TradingPostMenu(int containerId, Inventory inventory) {
        this(containerId, inventory, new MerchantCollection(), ContainerLevelAccess.NULL);
    }

    public TradingPostMenu(int containerId, Inventory inventory, MerchantCollection merchantCollection, ContainerLevelAccess worldPosCallable) {
        super(containerId, inventory, (Merchant)merchantCollection);
        this.access = worldPosCallable;
        this.traders = merchantCollection;
        ((MerchantMenuAccessor)((Object)this)).tradingpost$setTrader(this.traders);
        this.tradeContainer = new TradingPostContainer(this.traders);
        ((MerchantMenuAccessor)((Object)this)).tradingpost$setTradeContainer(this.tradeContainer);
        this.replaceSlot(0, new Slot((Container)this.tradeContainer, 0, 136, 37));
        this.replaceSlot(1, new Slot((Container)this.tradeContainer, 1, 162, 37));
        this.replaceSlot(2, (Slot)new MerchantResultSlot(inventory.player, (Merchant)this.traders, this.tradeContainer, 2, 220, 37));
    }

    private void replaceSlot(int index, Slot slot) {
        slot.index = index;
        this.slots.set(index, (Object)slot);
    }

    public MenuType<?> getType() {
        return (MenuType)ModRegistry.TRADING_POST_MENU_TYPE.value();
    }

    public boolean stillValid(Player player) {
        Optional anyTrader = this.access.evaluate((level, pos) -> {
            boolean testRange = ((ServerConfig)TradingPost.CONFIG.get(ServerConfig.class)).enforceRange && ++this.ticks >= 20;
            return this.traders.updateAvailableMerchants(this.containerId, (BlockPos)pos, player, testRange);
        });
        if (this.ticks >= 20) {
            this.ticks = 0;
        }
        if (((ServerConfig)TradingPost.CONFIG.get(ServerConfig.class)).closeScreen && anyTrader.isPresent() && !((Boolean)anyTrader.get()).booleanValue()) {
            player.displayClientMessage(TradingPostBlock.MISSING_MERCHANT_COMPONENT, false);
            return false;
        }
        return TradingPostMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)ModRegistry.TRADING_POST_BLOCK.value()));
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (slotIndex == 2) {
                if (!this.moveItemStackTo(itemstack1, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
            } else {
                return super.quickMoveStack(player, slotIndex);
            }
            slot.onQuickCraft(itemstack1, itemstack);
            this.playTradeSound();
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }

    private void playTradeSound() {
        Merchant merchant;
        if (!this.traders.isClientSide() && (merchant = this.traders.getCurrentMerchant()) instanceof Entity) {
            Entity entity = (Entity)merchant;
            entity.level().playLocalSound(entity.getX(), entity.getY(), entity.getZ(), this.traders.getNotifyTradeSound(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
        }
    }

    public void clearPaymentSlots() {
        ItemStack itemstack1;
        ItemStack itemstack = this.tradeContainer.getItem(0);
        if (!itemstack.isEmpty()) {
            if (!this.moveItemStackTo(itemstack, 3, 39, true)) {
                return;
            }
            this.tradeContainer.setItem(0, itemstack);
        }
        if (!(itemstack1 = this.tradeContainer.getItem(1)).isEmpty()) {
            if (!this.moveItemStackTo(itemstack1, 3, 39, true)) {
                return;
            }
            this.tradeContainer.setItem(1, itemstack1);
        }
    }

    public MerchantOffers getOffers() {
        return this.lockOffers ? new MerchantOffers() : super.getOffers();
    }

    public MerchantCollection getTraders() {
        return this.traders;
    }

    public void lockOffers(boolean lock) {
        this.lockOffers = lock;
    }

    public void addMerchant(Player player, int merchantId, Component merchantTitle, MerchantOffers offers, int villagerLevel, int villagerXp, boolean showProgress, boolean canRestock) {
        LocalMerchant merchant = new LocalMerchant(player, merchantTitle, offers, villagerLevel, villagerXp, showProgress, canRestock);
        this.traders.addMerchant(merchantId, (Merchant)merchant);
    }

    public int getTraderLevel() {
        return this.traders.getTraderLevel();
    }

    public boolean canRestock() {
        return this.traders.canRestock();
    }

    public boolean showProgressBar() {
        return this.traders.showProgressBar();
    }

    public void setShowProgressBar(boolean showProgressBar) {
    }

    public void setXp(int xpValue) {
    }

    public void setMerchantLevel(int merchantLevel) {
    }

    public void setCanRestock(boolean canRestock) {
    }

    public void setOffers(MerchantOffers offers) {
    }
}

