/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tradingpost.network;

import fuzs.puzzleslib.api.network.v2.MessageV2;
import fuzs.tradingpost.world.inventory.TradingPostMenu;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class S2CRemoveMerchantsMessage
implements MessageV2<S2CRemoveMerchantsMessage> {
    private int containerId;
    private IntSet merchantIds;

    public S2CRemoveMerchantsMessage() {
    }

    public S2CRemoveMerchantsMessage(int containerId, IntSet merchantIds) {
        this.containerId = containerId;
        this.merchantIds = merchantIds;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeVarInt(this.containerId);
        buf.writeVarInt(this.merchantIds.size());
        IntIterator intIterator = this.merchantIds.iterator();
        while (intIterator.hasNext()) {
            int merchantId = (Integer)intIterator.next();
            buf.writeInt(merchantId);
        }
    }

    public void read(FriendlyByteBuf buf) {
        this.containerId = buf.readVarInt();
        int length = buf.readVarInt();
        IntOpenHashSet merchantIds = new IntOpenHashSet();
        for (int i = 0; i < length; ++i) {
            merchantIds.add(buf.readInt());
        }
        this.merchantIds = merchantIds;
    }

    public MessageV2.MessageHandler<S2CRemoveMerchantsMessage> makeHandler() {
        return new MessageV2.MessageHandler<S2CRemoveMerchantsMessage>(this){

            public void handle(S2CRemoveMerchantsMessage packet, Player player, Object gameInstance) {
                AbstractContainerMenu container = player.containerMenu;
                if (packet.containerId == container.containerId && container instanceof TradingPostMenu) {
                    IntIterator intIterator = packet.merchantIds.iterator();
                    while (intIterator.hasNext()) {
                        int merchantId = (Integer)intIterator.next();
                        ((TradingPostMenu)container).getTraders().removeMerchant(merchantId);
                    }
                }
            }
        };
    }
}

