/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tradingpost.client;

import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.core.v1.context.BlockEntityRenderersContext;
import fuzs.puzzleslib.api.client.core.v1.context.MenuScreensContext;
import fuzs.puzzleslib.api.client.searchtree.v1.SearchRegistryHelper;
import fuzs.puzzleslib.api.client.searchtree.v1.SearchTreeType;
import fuzs.tradingpost.TradingPost;
import fuzs.tradingpost.client.gui.screens.inventory.TradingPostScreen;
import fuzs.tradingpost.client.renderer.blockentity.TradingPostRenderer;
import fuzs.tradingpost.init.ModRegistry;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.client.searchtree.FullTextSearchTree;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class TradingPostClient
implements ClientModConstructor {
    public static final SearchTreeType<MerchantOffer> MERCHANT_OFFERS_SEARCH_TREE = new SearchTreeType(TradingPost.id("merchant_offers"));

    public void onClientSetup() {
        SearchRegistryHelper.register(MERCHANT_OFFERS_SEARCH_TREE, values -> new FullTextSearchTree(offer -> Stream.of(offer.getBaseCostA(), offer.getCostB(), offer.getResult()).filter(Predicate.not(ItemStack::isEmpty)).flatMap(SearchRegistryHelper::getTooltipLines), offer -> Stream.of(offer.getBaseCostA(), offer.getCostB(), offer.getResult()).filter(Predicate.not(ItemStack::isEmpty)).map(ItemStack::getItem).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getKey(arg_0)), values));
    }

    public void onRegisterMenuScreens(MenuScreensContext context) {
        context.registerMenuScreen((MenuType)ModRegistry.TRADING_POST_MENU_TYPE.value(), TradingPostScreen::new);
    }

    public void onRegisterBlockEntityRenderers(BlockEntityRenderersContext context) {
        context.registerBlockEntityRenderer((BlockEntityType)ModRegistry.TRADING_POST_BLOCK_ENTITY_TYPE.value(), TradingPostRenderer::new);
    }
}

