/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.orediscoverybroadcast_common_neoforge.events;

import com.natamus.collective_common_neoforge.fakeplayer.FakePlayer;
import com.natamus.collective_common_neoforge.functions.HashMapFunctions;
import com.natamus.collective_common_neoforge.functions.StringFunctions;
import com.natamus.collective_common_neoforge.services.Services;
import com.natamus.orediscoverybroadcast_common_neoforge.config.ConfigHandler;
import com.natamus.orediscoverybroadcast_common_neoforge.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class MiningEvent {
    private static final HashMap<String, HashMap<String, Integer>> playerLastFoundTicks = new HashMap();

    public static void onBlockBreak(Level level, Player player, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        ResourceLocation defaultOreLocation;
        Block defaultOreBlock;
        Registry blockRegistry;
        ResourceLocation blockResourceLocation;
        if (level.isClientSide) {
            return;
        }
        if (ConfigHandler.onlyRunOnDedicatedServers && !level.getServer().isDedicatedServer()) {
            return;
        }
        if (ConfigHandler.ignoreFakePlayers && player instanceof FakePlayer) {
            return;
        }
        if (ConfigHandler.ignoreCreativePlayers && player.isCreative()) {
            return;
        }
        ItemStack handStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (!Services.TOOLFUNCTIONS.isPickaxe(handStack)) {
            return;
        }
        Block block = state.getBlock();
        if (!Util.isOre(state, block)) {
            return;
        }
        if (Util.blockBlacklist.contains(block)) {
            return;
        }
        int playerTickCount = player.tickCount;
        String playerName = player.getName().getString();
        String oreName = block.getName().getString();
        if (ConfigHandler.hideDeepslateFromName && (blockResourceLocation = (blockRegistry = level.registryAccess().registryOrThrow(Registries.BLOCK)).getKey((Object)block)).toString().contains("deepslate_") && (defaultOreBlock = (Block)blockRegistry.get(defaultOreLocation = ResourceLocation.parse((String)blockResourceLocation.toString().replace("deepslate_", "")))) != null) {
            oreName = defaultOreBlock.getName().getString();
        }
        if (ConfigHandler.lowercaseOreName) {
            oreName = oreName.toLowerCase();
        }
        boolean shouldBroadcast = true;
        if (!playerLastFoundTicks.containsKey(playerName)) {
            playerLastFoundTicks.put(playerName, new HashMap());
        } else {
            int lastFoundTicks;
            HashMap<String, Integer> lastFound = playerLastFoundTicks.get(playerName);
            if (lastFound.containsKey(oreName) && playerTickCount - (lastFoundTicks = lastFound.get(oreName).intValue()) <= ConfigHandler.tickDelayBetweenSameOreBroastcasts) {
                shouldBroadcast = false;
            }
        }
        if (shouldBroadcast && !Util.shouldBeIgnored(level, pos)) {
            Object formattedOreName = oreName;
            if (ConfigHandler.addOreCountToMessage) {
                int oreCount = Util.getOreCount(level, pos, block);
                formattedOreName = oreCount + " " + (String)formattedOreName;
            }
            String message = ConfigHandler.messageFormat.replace("%player%", playerName).replace("%ore%", (CharSequence)formattedOreName);
            StringFunctions.broadcastMessage((Level)level, (String)message, (ChatFormatting)Util.getBroadcastColour(block));
        }
        playerLastFoundTicks.get(playerName).put(oreName, playerTickCount);
    }

    public static boolean onEntityBlockPlace(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack itemStack) {
        if (level.isClientSide) {
            return true;
        }
        if (!ConfigHandler.ignorePlacedOreBlocks) {
            return true;
        }
        if (!(entity instanceof Player)) {
            return true;
        }
        if (Util.isOre(state)) {
            ((List)HashMapFunctions.computeIfAbsent(Util.ignoredOreBlockPositions, (Object)level, k -> new ArrayList())).add(pos.immutable());
        }
        return true;
    }
}

