/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.orediscoverybroadcast_common_fabric.util;

import com.natamus.collective_common_fabric.functions.BlockPosFunctions;
import com.natamus.collective_common_fabric.functions.DataFunctions;
import com.natamus.collective_common_fabric.functions.HashMapFunctions;
import com.natamus.collective_common_fabric.functions.NumberFunctions;
import com.natamus.collective_common_fabric.services.Services;
import com.natamus.orediscoverybroadcast_common_fabric.data.Constants;
import com.natamus.orediscoverybroadcast_common_fabric.data.Variables;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.WeakHashMap;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7924;

public class Util {
    public static final WeakHashMap<class_1937, List<class_2338>> ignoredOreBlockPositions = new WeakHashMap();
    public static List<class_2248> blockBlacklist = new ArrayList<class_2248>();
    private static final HashMap<class_2248, class_124> blockColourMap = new HashMap();
    private static final HashMap<class_2248, class_124> defaultColourMap = new HashMap();
    private static final String dirpath = DataFunctions.getConfigDirectory() + File.separator + "orediscoverybroadcast";
    private static final File dir = new File(dirpath);
    private static final File blacklistFile = new File(dirpath + File.separator + "blacklist.txt");
    private static final File colourMapFile = new File(dirpath + File.separator + "colourmap.txt");

    public static void attemptConfigProcessing(class_1937 level) {
        if (!Variables.processedConfig) {
            try {
                Util.processConfig(level);
                Variables.processedConfig = true;
            }
            catch (Exception ex) {
                Constants.logger.warn("[Ore Discovery Broadcast] Error: Unable to generate config.");
                ex.printStackTrace();
            }
        }
    }

    public static void processConfig(class_1937 level) throws IOException {
        Util.setDefaultColourMap();
        class_2378 blockRegistry = level.method_30349().method_30530(class_7924.field_41254);
        PrintWriter blacklistWriter = null;
        PrintWriter colourMapWriter = null;
        if (blacklistFile.isFile() && colourMapFile.isFile()) {
            String blacklistContent = new String(Files.readAllBytes(Paths.get(dirpath + File.separator + "blacklist.txt", new String[0])));
            for (String line : blacklistContent.split(",")) {
                if (line.contains("//") || (line = line.strip()).isEmpty() || !line.startsWith("!")) continue;
                String blockName = line.replace("\n", "").replace("!", "").trim();
                class_2960 blockRL = class_2960.method_60654((String)blockName);
                class_2248 block = (class_2248)blockRegistry.method_10223(blockRL);
                if (block == null) {
                    Constants.logger.warn("[Ore Discovery Broadcast] Unable to find block with resource location: " + line);
                    continue;
                }
                blockBlacklist.add(block);
            }
            String colourMapContent = new String(Files.readAllBytes(Paths.get(dirpath + File.separator + "colourmap.txt", new String[0])));
            for (String line : colourMapContent.split(",")) {
                if (line.contains("//") || (line = line.trim()).isEmpty()) continue;
                String[] lspl = line.split("\\|");
                if (lspl.length != 2) {
                    Constants.logger.warn("[Ore Discovery Broadcast] Incorrect split length in line: " + line);
                    continue;
                }
                String blockName = lspl[0].replace("\n", "").trim();
                String colourIndexString = lspl[1].replace("\n", "").trim();
                if (!NumberFunctions.isNumeric((String)colourIndexString)) {
                    Constants.logger.warn("[Ore Discovery Broadcast] The colour index " + colourIndexString + " is not a number.");
                    continue;
                }
                class_2960 blockRL = class_2960.method_60654((String)blockName);
                class_2248 block = (class_2248)blockRegistry.method_10223(blockRL);
                int colourIndex = Integer.parseInt(colourIndexString);
                class_124 colour = class_124.method_534((int)colourIndex);
                if (colour == null) {
                    Constants.logger.warn("[Ore Discovery Broadcast] Unable to find colour for colour id: " + colourIndex);
                    continue;
                }
                blockColourMap.put(block, colour);
            }
            return;
        }
        if (!dir.isDirectory()) {
            boolean blacklistContent = dir.mkdirs();
        }
        if (!blacklistFile.isFile()) {
            blacklistWriter = new PrintWriter(dirpath + File.separator + "blacklist.txt", StandardCharsets.UTF_8);
            blacklistWriter.println("// To add an ore to the blacklist; add an exclamation mark (!) in front of it,\n");
        }
        if (!colourMapFile.isFile()) {
            colourMapWriter = new PrintWriter(dirpath + File.separator + "colourmap.txt", StandardCharsets.UTF_8);
            colourMapWriter.println("// To change the colour of the broadcasted message; change the number behind the ore,");
            colourMapWriter.println("// Possible colours; black=0; dark_blue=1; dark_green=2; dark_aqua=3; dark_red=4; dark_purple=5; gold=6; gray=7; dark_gray=8; blue=9; green=10; aqua=11; red=12; light_purple=13; yellow=14; white=15,\n");
        }
        ArrayList<String> oreBlockNames = new ArrayList<String>();
        HashMap<String, class_2248> oreBlockMap = new HashMap<String, class_2248>();
        for (class_2248 block : blockRegistry) {
            class_2960 rl;
            if (!Util.isOre(block) || (rl = blockRegistry.method_10221((Object)block)) == null) continue;
            oreBlockNames.add(rl.toString());
            oreBlockMap.put(rl.toString(), block);
        }
        Collections.sort(oreBlockNames);
        for (String oreBlockName : oreBlockNames) {
            class_2248 block = (class_2248)oreBlockMap.get(oreBlockName);
            String prefix = "";
            if (oreBlockName.contains("quartz")) {
                prefix = "!";
            }
            if (blacklistWriter != null) {
                blacklistWriter.println(prefix + oreBlockName + ",");
            }
            int colourIndex = 9;
            if (defaultColourMap.containsKey(block)) {
                colourIndex = defaultColourMap.get(block).method_536();
            }
            if (colourMapWriter != null) {
                colourMapWriter.println(oreBlockName + "|" + colourIndex + ",");
            }
            blockColourMap.put(block, class_124.method_534((int)colourIndex));
        }
        if (blacklistWriter != null) {
            blacklistWriter.close();
        }
        if (colourMapWriter != null) {
            colourMapWriter.close();
        }
    }

    private static void setDefaultColourMap() {
        defaultColourMap.put(class_2246.field_22109, class_124.field_1064);
        defaultColourMap.put(class_2246.field_10418, class_124.field_1063);
        defaultColourMap.put(class_2246.field_29219, class_124.field_1063);
        defaultColourMap.put(class_2246.field_27120, class_124.field_1054);
        defaultColourMap.put(class_2246.field_29221, class_124.field_1054);
        defaultColourMap.put(class_2246.field_10442, class_124.field_1075);
        defaultColourMap.put(class_2246.field_29029, class_124.field_1075);
        defaultColourMap.put(class_2246.field_10013, class_124.field_1077);
        defaultColourMap.put(class_2246.field_29220, class_124.field_1077);
        defaultColourMap.put(class_2246.field_10571, class_124.field_1065);
        defaultColourMap.put(class_2246.field_29026, class_124.field_1065);
        defaultColourMap.put(class_2246.field_23077, class_124.field_1065);
        defaultColourMap.put(class_2246.field_10212, class_124.field_1080);
        defaultColourMap.put(class_2246.field_29027, class_124.field_1080);
        defaultColourMap.put(class_2246.field_10090, class_124.field_1078);
        defaultColourMap.put(class_2246.field_10213, class_124.field_1068);
        defaultColourMap.put(class_2246.field_10080, class_124.field_1061);
    }

    public static boolean isOre(class_2680 blockState) {
        return Util.isOre(blockState, blockState.method_26204());
    }

    public static boolean isOre(class_2248 block) {
        return Util.isOre(block.method_9564(), block);
    }

    public static boolean isOre(class_2680 blockState, class_2248 block) {
        return Services.BLOCKTAGS.isOre(blockState) || block.equals(class_2246.field_22109);
    }

    public static class_124 getBroadcastColour(class_2248 block) {
        if (blockColourMap.containsKey(block)) {
            return blockColourMap.get(block);
        }
        return class_124.field_1078;
    }

    public static boolean shouldBeIgnored(class_1937 level, class_2338 blockPos) {
        boolean shouldIgnore = ((List)HashMapFunctions.computeIfAbsent(ignoredOreBlockPositions, (Object)level, k -> new ArrayList())).contains(blockPos);
        ignoredOreBlockPositions.get(level).remove(blockPos);
        return shouldIgnore;
    }

    public static int getOreCount(class_1937 level, class_2338 blockPos, class_2248 block) {
        if (!ignoredOreBlockPositions.containsKey(level)) {
            ignoredOreBlockPositions.put(level, new ArrayList());
        }
        int addSize = 1;
        List connectedOres = BlockPosFunctions.getBlocksNextToEachOther((class_1937)level, (class_2338)blockPos, Arrays.asList(block));
        for (class_2338 connectedPos : connectedOres) {
            if (!ignoredOreBlockPositions.get(level).contains(connectedPos)) {
                ignoredOreBlockPositions.get(level).add(connectedPos);
                continue;
            }
            --addSize;
        }
        return connectedOres.size() + addSize;
    }
}

