/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.control.collection;

import team.creative.creativecore.client.render.text.CompiledText;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.control.collection.GuiComboBoxColumn;
import team.creative.creativecore.common.gui.control.parent.GuiScrollY;
import team.creative.creativecore.common.gui.control.simple.GuiRowLabel;
import team.creative.creativecore.common.gui.control.simple.GuiTextfield;
import team.creative.creativecore.common.gui.extension.GuiExtensionCreator;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.type.list.Tuple;
import team.creative.creativecore.common.util.type.list.TupleList;

public class GuiComboBoxExtensionColumn
extends GuiScrollY {
    public GuiExtensionCreator<? extends GuiComboBoxColumn<?>, ? extends GuiComboBoxExtensionColumn> creator;
    public String search = "";
    public int columns;

    public GuiComboBoxExtensionColumn(String name, GuiExtensionCreator<? extends GuiComboBoxColumn<?>, ? extends GuiComboBoxExtensionColumn> creator) {
        super(name);
        this.creator = creator;
        this.registerEventChanged(event -> {
            if (event.control.is("searchBar")) {
                this.search = ((GuiTextfield)event.control).getText();
                this.reloadControls();
            }
        });
        this.reloadControls();
    }

    @Override
    public void looseFocus() {
        this.creator.markLostFocus();
    }

    public void reloadControls() {
        GuiComboBoxColumn box;
        if (this.creator == null) {
            return;
        }
        GuiTextfield textfield = (GuiTextfield)this.get("searchBar");
        this.clear();
        if (this.search != null && this.search.isBlank()) {
            this.search = null;
        }
        if ((box = (GuiComboBoxColumn)this.creator.parent).hasSearchbar()) {
            if (textfield == null) {
                textfield = new GuiTextfield("searchBar", this.search == null ? "" : this.search);
                this.add(textfield.setExpandableX());
            }
            textfield.focus();
        }
        GuiParent lower = new GuiParent();
        this.add((GuiControl)lower);
        lower.flow = GuiFlow.FIT_X;
        for (TupleList col : box.columns) {
            int i = 0;
            for (Tuple tuple : col) {
                if (this.search == null || ((CompiledText)tuple.value).contains(this.search)) {
                    lower.add((GuiControl)new GuiRowLabel("" + i, i, i == box.selectedIndex(), x -> {
                        ((GuiComboBoxColumn)this.creator.parent).select(tuple.key);
                        this.creator.close();
                    }).set(((CompiledText)tuple.value).copy()));
                }
                ++i;
            }
        }
        if (this.hasGui()) {
            this.rect.flowX();
            this.rect.flowY();
        }
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        if (super.mouseClicked(x, y, button)) {
            this.creator.markKeptFocus();
            return true;
        }
        return false;
    }

    @Override
    protected int maxHeight(int width, int availableWidth) {
        return 100;
    }
}

