/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.control.collection;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import team.creative.creativecore.client.render.text.CompiledText;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.control.collection.GuiComboBoxExtensionColumn;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.extension.GuiExtensionCreator;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.text.IComponentMap;
import team.creative.creativecore.common.util.type.list.Tuple;
import team.creative.creativecore.common.util.type.list.TupleList;

public class GuiComboBoxColumn<K>
extends GuiLabel {
    protected GuiExtensionCreator<GuiComboBoxColumn<K>, GuiComboBoxExtensionColumn> ex = new GuiExtensionCreator(this);
    protected TupleList<K, CompiledText> data;
    protected List<TupleList<K, CompiledText>> columns;
    private int index;
    private K selected;
    private boolean searchbar;
    private GuiExtensionCreator.ExtensionDirection direction = GuiExtensionCreator.ExtensionDirection.BELOW_OR_ABOVE;

    public GuiComboBoxColumn(String name, K selected, List<IComponentMap<K>> builder) {
        this(name, builder);
        this.select(selected);
    }

    public GuiComboBoxColumn(String name, List<IComponentMap<K>> builder) {
        super(name);
        this.set(builder);
    }

    public boolean hasSearchbar() {
        return this.searchbar;
    }

    public GuiComboBoxColumn setSearchbar(boolean searchbar) {
        this.searchbar = searchbar;
        return this;
    }

    public GuiComboBoxColumn setDirection(GuiExtensionCreator.ExtensionDirection direction) {
        this.direction = direction;
        return this;
    }

    public void set(List<IComponentMap<K>> builder) {
        this.columns = new ArrayList<TupleList<K, CompiledText>>();
        this.data = new TupleList();
        for (IComponentMap<K> map : builder) {
            TupleList<K, CompiledText> col = map.build();
            this.columns.add(col);
            for (Tuple tuple : col) {
                this.data.add(tuple.key, (CompiledText)tuple.value);
            }
        }
        this.select(this.index);
        for (CompiledText text : this.data.values()) {
            text.setAlign(Align.CENTER);
        }
        this.updateDisplay();
    }

    @Nullable
    public K selected() {
        return this.selected;
    }

    public K selected(K defaultValue) {
        K s = this.selected();
        if (s != null) {
            return s;
        }
        return defaultValue;
    }

    private void select(int index) {
        this.index = Mth.clamp((int)index, (int)0, (int)(this.data.size() - 1));
        this.selected = !this.data.isEmpty() ? ((Tuple)this.data.get((int)this.index)).key : null;
        this.updateDisplay();
        this.raiseEvent(new GuiControlChangedEvent<GuiComboBoxColumn>(this));
    }

    public void select(K key) {
        this.select(this.indexOf(key));
    }

    public int indexOf(K key) {
        for (int i = 0; i < this.data.size(); ++i) {
            if (!Objects.equals(((Tuple)this.data.get((int)i)).key, key)) continue;
            return i;
        }
        return -1;
    }

    public void next() {
        int index = this.index + 1;
        if (index >= this.data.size()) {
            index = 0;
        }
        this.select(index);
    }

    public void previous() {
        int index = this.index - 1;
        if (index < 0) {
            index = this.data.size() - 1;
        }
        this.select(index);
    }

    protected void updateDisplay() {
        this.text = this.index >= 0 && this.index < this.data.size() ? (CompiledText)((Tuple)this.data.get((int)this.index)).value : CompiledText.EMPTY;
    }

    @Override
    public void flowX(int width, int preferred) {
        for (CompiledText text : this.data.values()) {
            text.setDimension(width, Integer.MAX_VALUE);
        }
    }

    @Override
    public void flowY(int width, int height, int preferred) {
        for (CompiledText text : this.data.values()) {
            text.setMaxHeight(height);
        }
    }

    @Override
    public int preferredWidth(int availableWidth) {
        int width = 0;
        for (CompiledText text : this.data.values()) {
            width = Math.max(width, text.getTotalWidth() + 3);
        }
        return width;
    }

    @Override
    public int preferredHeight(int width, int availableHeight) {
        int height = 0;
        for (CompiledText text : this.data.values()) {
            height = Math.max(height, text.getTotalHeight());
        }
        return height;
    }

    public int selectedIndex() {
        return this.index;
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        this.ex.toggle(this::createBox, this.direction);
        GuiComboBoxColumn.playSound((Holder.Reference<SoundEvent>)SoundEvents.UI_BUTTON_CLICK);
        return true;
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.CLICKABLE;
    }

    protected GuiComboBoxExtensionColumn createBox(GuiExtensionCreator<GuiComboBoxColumn<K>, GuiComboBoxExtensionColumn> creator) {
        return new GuiComboBoxExtensionColumn(this.name + "extension", creator);
    }

    @Override
    public void looseFocus() {
        if (this.ex.checkShouldClose()) {
            this.ex.close();
        }
    }

    public Iterable<CompiledText> lines() {
        return this.data.values();
    }
}

