/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplylight.blocks;

import com.flanks255.simplylight.blocks.LampBase;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LampPost
extends LampBase
implements SimpleWaterloggedBlock {
    public static final EnumProperty<Position> POSITION = EnumProperty.create((String)"position", Position.class);
    private static final VoxelShape TOP_SHAPE = Stream.of(Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)5.0, (double)10.0), Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0), Block.box((double)3.0, (double)6.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0)).reduce((a, b) -> Shapes.join((VoxelShape)a, (VoxelShape)b, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape MIDDLE_SHAPE = Stream.of(Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0), Block.box((double)5.0, (double)10.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0)).reduce((a, b) -> Shapes.join((VoxelShape)a, (VoxelShape)b, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape BOTTOM_SHAPE = Stream.of(Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0), Block.box((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0), Block.box((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0)).reduce((a, b) -> Shapes.join((VoxelShape)a, (VoxelShape)b, (BooleanOp)BooleanOp.OR)).get();
    public final DyeColor color;

    public LampPost(DyeColor color) {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).pushReaction(PushReaction.DESTROY).lightLevel(bState -> bState.getValue(POSITION) == Position.TOP ? 15 : 0).strength(1.0f));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.color = color;
    }

    public boolean isPathfindable(@Nonnull BlockState pState, @Nonnull PathComputationType pType) {
        return false;
    }

    public boolean canPlaceLiquid(Player player, @Nonnull BlockGetter pLevel, @Nonnull BlockPos pPos, @Nonnull BlockState pState, @Nonnull Fluid pFluid) {
        return super.canPlaceLiquid(player, pLevel, pPos, pState, pFluid);
    }

    @Nonnull
    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState);
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState pState, @Nonnull BlockGetter pLevel, @Nonnull BlockPos pPos, @Nonnull CollisionContext pContext) {
        return switch (((Position)((Object)pState.getValue(POSITION))).ordinal()) {
            case 2 -> TOP_SHAPE;
            case 1 -> MIDDLE_SHAPE;
            default -> BOTTOM_SHAPE;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.add(new Property[]{POSITION, BlockStateProperties.WATERLOGGED});
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, @Nonnull ItemStack pStack) {
        pLevel.setBlock(pPos.above(), (BlockState)pState.setValue(POSITION, (Comparable)((Object)Position.MIDDLE)), 3);
        pLevel.setBlock(pPos.above(2), (BlockState)pState.setValue(POSITION, (Comparable)((Object)Position.TOP)), 3);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockPos clickedPos = pContext.getClickedPos();
        Level level = pContext.getLevel();
        if (clickedPos.getY() < level.getMaxBuildHeight() - 2 && level.getBlockState(clickedPos.above()).canBeReplaced(pContext) && level.getBlockState(clickedPos.above(2)).canBeReplaced(pContext)) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue(POSITION, (Comparable)((Object)Position.BOTTOM))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        return null;
    }

    public void onRemove(@Nonnull BlockState pState, @Nonnull Level pLevel, @Nonnull BlockPos pPos, @Nonnull BlockState pNewState, boolean pIsMoving) {
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
        if (pNewState.getBlock() == this) {
            return;
        }
        switch (((Position)((Object)pState.getValue(POSITION))).ordinal()) {
            case 2: {
                if (pLevel.getBlockState(pPos.below()).getBlock() instanceof LampPost) {
                    pLevel.setBlockAndUpdate(pPos.below(), Blocks.AIR.defaultBlockState());
                }
                if (!(pLevel.getBlockState(pPos.below(2)).getBlock() instanceof LampPost)) break;
                pLevel.setBlockAndUpdate(pPos.below(2), Blocks.AIR.defaultBlockState());
                break;
            }
            case 1: {
                if (pLevel.getBlockState(pPos.below()).getBlock() instanceof LampPost) {
                    pLevel.setBlockAndUpdate(pPos.below(), Blocks.AIR.defaultBlockState());
                }
                if (!(pLevel.getBlockState(pPos.above()).getBlock() instanceof LampPost)) break;
                pLevel.setBlockAndUpdate(pPos.above(), Blocks.AIR.defaultBlockState());
                break;
            }
            case 0: {
                if (pLevel.getBlockState(pPos.above()).getBlock() instanceof LampPost) {
                    pLevel.setBlockAndUpdate(pPos.above(), Blocks.AIR.defaultBlockState());
                }
                if (!(pLevel.getBlockState(pPos.above(2)).getBlock() instanceof LampPost)) break;
                pLevel.setBlockAndUpdate(pPos.above(2), Blocks.AIR.defaultBlockState());
            }
        }
    }

    @Override
    public void addLang(BiConsumer<String, String> consumer) {
        String colorname;
        String base = this.getDescriptionId();
        switch (this.color) {
            case RED: {
                String string = "Red";
                break;
            }
            case BLUE: {
                String string = "Blue";
                break;
            }
            case CYAN: {
                String string = "Cyan";
                break;
            }
            case GRAY: {
                String string = "Gray";
                break;
            }
            case LIME: {
                String string = "Lime";
                break;
            }
            case MAGENTA: {
                String string = "Magenta";
                break;
            }
            case PINK: {
                String string = "Pink";
                break;
            }
            case BLACK: {
                String string = "Black";
                break;
            }
            case BROWN: {
                String string = "Brown";
                break;
            }
            case GREEN: {
                String string = "Green";
                break;
            }
            case ORANGE: {
                String string = "Orange";
                break;
            }
            case PURPLE: {
                String string = "Purple";
                break;
            }
            case YELLOW: {
                String string = "Yellow";
                break;
            }
            case LIGHT_BLUE: {
                String string = "Light Blue";
                break;
            }
            case LIGHT_GRAY: {
                String string = "Light Gray";
                break;
            }
            default: {
                String string = colorname = "";
            }
        }
        if (this.color == DyeColor.WHITE) {
            consumer.accept(base, "Illuminant Column");
        } else {
            consumer.accept(base, "Illuminant " + colorname + " Column");
        }
        if (this.color != DyeColor.WHITE) {
            return;
        }
        consumer.accept(base + ".info", "3 Block tall lamp post.");
        consumer.accept(base + ".info2", "Top block emits light.");
    }

    public static enum Position implements StringRepresentable
    {
        BOTTOM("bottom"),
        MIDDLE("middle"),
        TOP("top");

        private final String name;

        private Position(String name) {
            this.name = name;
        }

        @Nonnull
        public String getSerializedName() {
            return this.name;
        }
    }
}

