/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks.jei;

import dev.shadowsoffire.hostilenetworks.Hostile;
import dev.shadowsoffire.hostilenetworks.HostileNetworks;
import dev.shadowsoffire.hostilenetworks.data.ModelTier;
import dev.shadowsoffire.hostilenetworks.data.ModelTierRegistry;
import dev.shadowsoffire.hostilenetworks.jei.TickingDataModelWrapper;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.text.DecimalFormat;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public class SimChamberCategory
implements IRecipeCategory<TickingDataModelWrapper> {
    public static final RecipeType<TickingDataModelWrapper> TYPE = RecipeType.create((String)"hostilenetworks", (String)"sim_chamber", TickingDataModelWrapper.class);
    public static final ResourceLocation TEXTURES = HostileNetworks.loc("textures/jei/sim_chamber.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final Component name;
    private int ticks = -1;
    private long lastTickTime = -1L;
    static List<TickingDataModelWrapper> recipes;
    private DynamicHolder<ModelTier> currentTier = ModelTierRegistry.INSTANCE.emptyHolder();

    public SimChamberCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURES, 0, 0, 116, 43);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(Hostile.Items.SIM_CHAMBER));
        this.name = Component.translatable((String)((Block)Hostile.Blocks.SIM_CHAMBER.value()).getDescriptionId());
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public Component getTitle() {
        return this.name;
    }

    public RecipeType<TickingDataModelWrapper> getRecipeType() {
        return TYPE;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, TickingDataModelWrapper recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 4, 4).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)recipe.model);
        builder.addSlot(RecipeIngredientRole.INPUT, 28, 4).addIngredients(recipe.input);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 96, 4).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)recipe.baseDrop);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 66, 26).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)recipe.prediction);
    }

    public void draw(TickingDataModelWrapper recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics gfx, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.getInstance();
        Font font = mc.font;
        long time = mc.level.getGameTime();
        int width = Mth.ceil((float)(35.0f * ((float)(this.ticks % 40) + mc.getTimer().getGameTimeDeltaPartialTick(true)) / 40.0f));
        gfx.blit(TEXTURES, 52, 9, 0.0f, 43.0f, width, 6, 256, 256);
        if (!this.currentTier.isBound()) {
            this.currentTier = ModelTierRegistry.INSTANCE.holder(ModelTierRegistry.getMinTier());
        }
        if (time != this.lastTickTime) {
            if (++this.ticks % 50 == 0) {
                ModelTier tier = (ModelTier)this.currentTier.get();
                ModelTier next = tier.isMax() ? ModelTierRegistry.getMinTier() : ModelTierRegistry.next(tier);
                while (!next.canSim()) {
                    next = ModelTierRegistry.next(next);
                }
                for (TickingDataModelWrapper t : recipes) {
                    t.setTier(next);
                }
                this.currentTier = ModelTierRegistry.INSTANCE.holder(next);
            }
            this.lastTickTime = time;
        }
        Component comp = recipe.currentTier.getComponent();
        width = font.width((FormattedText)comp);
        gfx.drawString(font, recipe.currentTier.getComponent(), 33 - width / 2, 30, recipe.currentTier.colorValue());
        DecimalFormat fmt = new DecimalFormat("##.##%");
        String msg = fmt.format(recipe.currentTier.accuracy());
        width = font.width(msg);
        gfx.drawString(font, msg, 114 - width, 30, 0xFFFFFF, true);
    }
}

