/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.hostilenetworks.Hostile;
import dev.shadowsoffire.hostilenetworks.HostileNetworks;
import dev.shadowsoffire.hostilenetworks.data.ModelTier;
import dev.shadowsoffire.hostilenetworks.data.ModelTierRegistry;
import dev.shadowsoffire.hostilenetworks.item.DataModelItem;
import dev.shadowsoffire.hostilenetworks.util.MiscCodecs;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.json.NBTAdapter;
import dev.shadowsoffire.placebo.json.OptionalStackCodec;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public record DataModel(EntityType<?> entity, List<EntityType<?>> variants, Component name, DisplayData display, int simCost, Ingredient input, ItemStack baseDrop, String triviaKey, List<ItemStack> fabDrops, RequiredData requiredData, DataPerKill dataPerKill) implements CodecProvider<DataModel>
{
    public static final Codec<DataModel> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("entity").forGetter(DataModel::entity), (App)MiscCodecs.OPTIONAL_ENTITY_TYPE_LIST.optionalFieldOf("variants", List.of()).forGetter(DataModel::variants), (App)ComponentSerialization.CODEC.fieldOf("name").forGetter(DataModel::name), (App)DisplayData.CODEC.optionalFieldOf("display", (Object)DisplayData.DEFAULT).forGetter(DataModel::display), (App)Codec.intRange((int)0, (int)0x6666666).fieldOf("sim_cost").forGetter(DataModel::simCost), (App)Ingredient.CODEC_NONEMPTY.fieldOf("input").forGetter(DataModel::input), (App)OptionalStackCodec.INSTANCE.fieldOf("base_drop").forGetter(DataModel::baseDrop), (App)Codec.STRING.fieldOf("trivia").forGetter(DataModel::triviaKey), (App)OptionalStackCodec.INSTANCE.listOf().xmap(DataModel::removeEmptyStacks, Function.identity()).fieldOf("fabricator_drops").forGetter(DataModel::fabDrops), (App)RequiredData.CODEC.optionalFieldOf("required_data", (Object)RequiredData.EMPTY).forGetter(DataModel::requiredData), (App)DataPerKill.CODEC.optionalFieldOf("data_per_kill", (Object)DataPerKill.EMPTY).forGetter(DataModel::dataPerKill)).apply((Applicative)inst, DataModel::new)).validate(DataModel::validate);

    public DataModel(DataModel other, List<ItemStack> newResults) {
        this(other.entity, other.variants, other.name, other.display, other.simCost, other.input, other.baseDrop, other.triviaKey, newResults, other.requiredData, other.dataPerKill);
    }

    public int getRequiredData(ModelTier tier) {
        return this.requiredData.getRequiredData(tier);
    }

    public int getDataPerKill(ModelTier tier) {
        return this.dataPerKill.getDataPerKill(tier);
    }

    public ItemStack getPredictionDrop() {
        ItemStack stk = new ItemStack(Hostile.Items.PREDICTION);
        DataModelItem.setStoredModel(stk, this);
        return stk;
    }

    public int getNameColor() {
        return this.name.getStyle().getColor().getValue();
    }

    public Codec<? extends DataModel> getCodec() {
        return CODEC;
    }

    public Stream<EntityType<?>> entityAndVariants() {
        return Stream.concat(Stream.of(this.entity), this.variants.stream());
    }

    public static DataResult<DataModel> validate(DataModel model) {
        if (model.name().getStyle().getColor() == null) {
            return DataResult.error(() -> "A data model must supply a color for the name component.");
        }
        return DataResult.success((Object)model);
    }

    private static List<ItemStack> removeEmptyStacks(List<ItemStack> list) {
        return list.stream().filter(i -> !i.isEmpty()).toList();
    }

    private static Codec<DynamicHolder<ModelTier>> tierCodec() {
        return Codec.STRING.xmap(HostileNetworks::loc, ResourceLocation::getPath).xmap(arg_0 -> ((ModelTierRegistry)ModelTierRegistry.INSTANCE).holder(arg_0), DynamicHolder::getId);
    }

    public record DisplayData(CompoundTag nbt, float scale, float xOffset, float yOffset, float zOffset) {
        public static final DisplayData DEFAULT = new DisplayData(new CompoundTag(), 1.0f, 0.0f, 0.0f, 0.0f);
        public static final Codec<DisplayData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)NBTAdapter.EITHER_CODEC.optionalFieldOf("nbt", (Object)new CompoundTag()).forGetter(DisplayData::nbt), (App)Codec.floatRange((float)0.0f, (float)5.0f).optionalFieldOf("scale", (Object)Float.valueOf(1.0f)).forGetter(DisplayData::scale), (App)Codec.floatRange((float)-5.0f, (float)5.0f).optionalFieldOf("x_offset", (Object)Float.valueOf(0.0f)).forGetter(DisplayData::xOffset), (App)Codec.floatRange((float)-5.0f, (float)5.0f).optionalFieldOf("y_offset", (Object)Float.valueOf(0.0f)).forGetter(DisplayData::yOffset), (App)Codec.floatRange((float)-5.0f, (float)5.0f).optionalFieldOf("z_offset", (Object)Float.valueOf(0.0f)).forGetter(DisplayData::zOffset)).apply((Applicative)inst, DisplayData::new));
    }

    public record RequiredData(Reference2IntOpenHashMap<DynamicHolder<ModelTier>> overrides) {
        public static RequiredData EMPTY = new RequiredData((Reference2IntOpenHashMap<DynamicHolder<ModelTier>>)new Reference2IntOpenHashMap());
        public static final Codec<RequiredData> CODEC = Codec.unboundedMap(DataModel.tierCodec(), (Codec)Codec.intRange((int)0, (int)Integer.MAX_VALUE)).xmap(Reference2IntOpenHashMap::new, Function.identity()).xmap(RequiredData::new, RequiredData::overrides).validate(RequiredData::validate);

        public int getRequiredData(ModelTier tier) {
            return this.overrides.getOrDefault((Object)ModelTierRegistry.INSTANCE.holder(tier), tier.requiredData());
        }

        public static DataResult<RequiredData> validate(RequiredData data) {
            int last = -1;
            for (ModelTier tier : ModelTierRegistry.getSortedTiers()) {
                int reqData = data.getRequiredData(tier);
                if (reqData <= last) {
                    DynamicHolder holder = ModelTierRegistry.INSTANCE.holder(tier);
                    int _last = last;
                    return DataResult.error(() -> "Tier Data overrides must preserve the same ordering as the main tier list. Currently, the override for tier " + holder.getId().getPath() + " is invalid. Expected a value greater than " + _last + ", but got " + reqData);
                }
                last = reqData;
            }
            return DataResult.success((Object)data);
        }
    }

    public record DataPerKill(Reference2IntOpenHashMap<DynamicHolder<ModelTier>> overrides) {
        public static DataPerKill EMPTY = new DataPerKill((Reference2IntOpenHashMap<DynamicHolder<ModelTier>>)new Reference2IntOpenHashMap());
        public static final Codec<DataPerKill> CODEC = Codec.unboundedMap(DataModel.tierCodec(), (Codec)Codec.intRange((int)0, (int)Integer.MAX_VALUE)).xmap(Reference2IntOpenHashMap::new, Function.identity()).xmap(DataPerKill::new, DataPerKill::overrides);

        public int getDataPerKill(ModelTier tier) {
            return this.overrides.getOrDefault((Object)ModelTierRegistry.INSTANCE.holder(tier), tier.dataPerKill());
        }
    }
}

