/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.shadowsoffire.hostilenetworks.Hostile;
import dev.shadowsoffire.hostilenetworks.HostileConfig;
import dev.shadowsoffire.hostilenetworks.HostileNetworks;
import dev.shadowsoffire.hostilenetworks.command.GenerateModelCommand;
import dev.shadowsoffire.hostilenetworks.command.GiveModelCommand;
import dev.shadowsoffire.hostilenetworks.curios.CuriosCompat;
import dev.shadowsoffire.hostilenetworks.data.DataModel;
import dev.shadowsoffire.hostilenetworks.data.DataModelRegistry;
import dev.shadowsoffire.hostilenetworks.data.ModelTier;
import dev.shadowsoffire.hostilenetworks.data.ModelTierRegistry;
import dev.shadowsoffire.hostilenetworks.item.DataModelItem;
import dev.shadowsoffire.hostilenetworks.item.DeepLearnerItem;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.items.ComponentItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="hostilenetworks")
public class HostileEvents {
    @SubscribeEvent
    public static void cmds(RegisterCommandsEvent e) {
        LiteralArgumentBuilder builder = Commands.literal((String)"hostilenetworks");
        GenerateModelCommand.register((LiteralArgumentBuilder<CommandSourceStack>)builder);
        GiveModelCommand.register((LiteralArgumentBuilder<CommandSourceStack>)builder);
        e.getDispatcher().register(builder);
    }

    @SubscribeEvent
    public static void modelAttunement(PlayerInteractEvent.EntityInteractSpecific e) {
        if (!HostileConfig.rightClickToAttune) {
            return;
        }
        Player player = e.getEntity();
        ItemStack stack = player.getItemInHand(e.getHand());
        if (stack.is(Hostile.Items.BLANK_DATA_MODEL)) {
            if (!player.level().isClientSide) {
                DataModel model = DataModelRegistry.INSTANCE.getForEntity(e.getTarget().getType());
                if (model == null) {
                    MutableComponent msg = Component.translatable((String)"hostilenetworks.msg.no_model").withStyle(ChatFormatting.RED);
                    player.sendSystemMessage((Component)msg);
                    return;
                }
                MutableComponent msg = Component.translatable((String)"hostilenetworks.msg.built", (Object[])new Object[]{model.name()}).withStyle(ChatFormatting.GOLD);
                player.sendSystemMessage((Component)msg);
                ItemStack modelStack = new ItemStack(Hostile.Items.DATA_MODEL);
                DataModelItem.setStoredModel(modelStack, model);
                player.setItemInHand(e.getHand(), modelStack);
            }
            e.setCanceled(true);
            e.setCancellationResult(InteractionResult.CONSUME);
        }
    }

    @SubscribeEvent
    public static void kill(LivingDeathEvent e) {
        if (!HostileConfig.killModelUpgrade) {
            return;
        }
        LivingEntity killed = e.getEntity();
        LivingEntity livingEntity = killed.getKillCredit();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer p = (ServerPlayer)livingEntity;
            p.getInventory().items.stream().filter(s -> s.is(Hostile.Items.DEEP_LEARNER)).forEach(dl -> HostileEvents.updateModels(dl, killed.getType(), 0));
            if (p.getOffhandItem().is(Hostile.Items.DEEP_LEARNER)) {
                HostileEvents.updateModels(p.getOffhandItem(), killed.getType(), 0);
            }
            if (ModList.get().isLoaded("curios")) {
                CuriosCompat.tryUpdateDeepLearner((Player)p, killed.getType(), 0);
            }
        }
    }

    public static void updateModels(ItemStack learner, EntityType<?> type, int bonus) {
        ComponentItemHandler handler = DeepLearnerItem.getItemHandler(learner);
        for (int i = 0; i < 4; ++i) {
            DynamicHolder<DataModel> dModel;
            ItemStack model = handler.getStackInSlot(i);
            if (model.isEmpty() || (!(dModel = DataModelItem.getStoredModel(model)).isBound() || ((DataModel)dModel.get()).entity() != type) && !((DataModel)dModel.get()).variants().contains(type)) continue;
            int data = DataModelItem.getData(model);
            ModelTier tier = ModelTierRegistry.getByData((DataModel)dModel.get(), data);
            DataModelItem.setData(model, data + ((DataModel)dModel.get()).getDataPerKill(tier) + bonus);
            handler.setStackInSlot(i, model);
        }
    }

    @SubscribeEvent
    public static void reload(AddReloadListenerEvent e) {
        e.addListener((PreparableReloadListener)((ResourceManagerReloadListener)resman -> {
            HostileNetworks.cfg = HostileConfig.load();
        }));
    }

    @SubscribeEvent
    public static void sync(OnDatapackSyncEvent e) {
        HostileConfig.ConfigPayload msg = new HostileConfig.ConfigPayload();
        e.getRelevantPlayers().forEach(p -> PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]));
    }
}

