/*
 * Decompiled with CFR 0.152.
 */
package fuzs.bettertridents.mixin;

import fuzs.bettertridents.BetterTridents;
import fuzs.bettertridents.capability.TridentSlotCapability;
import fuzs.bettertridents.config.ServerConfig;
import fuzs.bettertridents.init.ModRegistry;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ThrownTrident.class})
abstract class ThrownTridentMixin
extends AbstractArrow {
    @Shadow
    @Final
    private static EntityDataAccessor<Byte> ID_LOYALTY;

    protected ThrownTridentMixin(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    protected void onBelowWorld() {
        Entity entity;
        if (!((ServerConfig)BetterTridents.CONFIG.get(ServerConfig.class)).returnTridentFromVoid) {
            super.onBelowWorld();
            return;
        }
        if ((Byte)this.entityData.get(ID_LOYALTY) > 0 && this.isAcceptibleReturnOwner() && (entity = this.getOwner()) instanceof Player) {
            Player player = (Player)entity;
            this.setNoPhysics(true);
            this.playerTouch(player);
            return;
        }
        super.onBelowWorld();
    }

    @Shadow
    private boolean isAcceptibleReturnOwner() {
        throw new RuntimeException();
    }

    @Inject(method={"tryPickup"}, at={@At(value="HEAD")}, cancellable=true)
    protected void tryPickup(Player player, CallbackInfoReturnable<Boolean> callback) {
        if (!((ServerConfig)BetterTridents.CONFIG.get(ServerConfig.class)).returnTridentToSlot) {
            return;
        }
        boolean addedToInventory = this.pickup == AbstractArrow.Pickup.ALLOWED ? ((TridentSlotCapability)ModRegistry.TRIDENT_SLOT_CAPABILITY.get((Object)((ThrownTrident)ThrownTrident.class.cast((Object)this)))).addItemToInventory(player, this.getPickupItem()) : super.tryPickup(player);
        if (!addedToInventory) {
            addedToInventory = this.isNoPhysics() && this.ownedBy((Entity)player) && ((TridentSlotCapability)ModRegistry.TRIDENT_SLOT_CAPABILITY.get((Object)((ThrownTrident)ThrownTrident.class.cast((Object)this)))).addItemToInventory(player, this.getPickupItem());
        }
        callback.setReturnValue((Object)addedToInventory);
    }
}

