/*
 * Decompiled with CFR 0.152.
 */
package fuzs.bettertridents.handler;

import fuzs.bettertridents.BetterTridents;
import fuzs.bettertridents.capability.LastDamageSourceCapability;
import fuzs.bettertridents.config.ServerConfig;
import fuzs.bettertridents.init.ModRegistry;
import fuzs.bettertridents.mixin.accessor.ThrownTridentAccessor;
import fuzs.bettertridents.world.entity.item.LoyalExperienceOrb;
import fuzs.bettertridents.world.entity.item.LoyalItemEntity;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.DefaultedInt;
import fuzs.puzzleslib.api.init.v3.registry.LookupHelper;
import java.util.Collection;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LoyalDropsHandler {
    public static EventResult onLivingDrops(LivingEntity entity, DamageSource damageSource, Collection<ItemEntity> drops, boolean recentlyHit) {
        if (!((ServerConfig)BetterTridents.CONFIG.get(ServerConfig.class)).loyaltyCapturesDrops) {
            return EventResult.PASS;
        }
        int loyaltyLevel = LoyalDropsHandler.getLoyaltyLevel(damageSource);
        if (loyaltyLevel > 0) {
            for (ItemEntity itemEntity : drops) {
                itemEntity = new LoyalItemEntity(itemEntity, damageSource.getEntity(), loyaltyLevel);
                entity.level().addFreshEntity((Entity)itemEntity);
            }
            return EventResult.INTERRUPT;
        }
        return EventResult.PASS;
    }

    public static EventResult onLivingExperienceDrop(LivingEntity entity, @Nullable Player attackingPlayer, DefaultedInt droppedExperience) {
        Entity entity2;
        if (!((ServerConfig)BetterTridents.CONFIG.get(ServerConfig.class)).loyaltyCapturesDrops) {
            return EventResult.PASS;
        }
        DamageSource damageSource = ((LastDamageSourceCapability)ModRegistry.LAST_DAMAGE_SOURCE_CAPABILITY.get((Object)entity)).getDamageSource();
        if (damageSource != null && (entity2 = damageSource.getEntity()) instanceof Player) {
            int loyaltyLevel;
            Player player = (Player)entity2;
            if (!entity.level().isClientSide && (loyaltyLevel = LoyalDropsHandler.getLoyaltyLevel(damageSource)) > 0) {
                LoyalDropsHandler.awardExperienceOrbs((ServerLevel)entity.level(), entity.position(), droppedExperience.getAsInt(), player, loyaltyLevel);
                return EventResult.INTERRUPT;
            }
        }
        return EventResult.PASS;
    }

    private static int getLoyaltyLevel(DamageSource source) {
        Entity entity = source.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Entity entity2 = source.getDirectEntity();
            if (entity2 instanceof ThrownTrident) {
                ThrownTrident trident = (ThrownTrident)entity2;
                return ((Byte)trident.getEntityData().get(ThrownTridentAccessor.getLoyaltyId())).byteValue();
            }
            Holder enchantment = LookupHelper.lookupEnchantment((Entity)player, (ResourceKey)Enchantments.LOYALTY);
            return EnchantmentHelper.getEnchantmentLevel((Holder)enchantment, (LivingEntity)player);
        }
        return 0;
    }

    public static void awardExperienceOrbs(ServerLevel level, Vec3 pos, int amount, Player player, int loyaltyLevel) {
        while (amount > 0) {
            int i = ExperienceOrb.getExperienceValue((int)amount);
            amount -= i;
            level.addFreshEntity((Entity)new LoyalExperienceOrb((Level)level, pos.x(), pos.y(), pos.z(), i, player.getUUID(), loyaltyLevel));
        }
    }

    public static void tickLoyalEntity(Entity entity, Player owner, int loyaltyLevel) {
        entity.xo = entity.getX();
        entity.yo = entity.getY();
        entity.zo = entity.getZ();
        entity.noPhysics = true;
        Vec3 vec3 = owner.getEyePosition().subtract(entity.position());
        entity.setPosRaw(entity.getX(), entity.getY() + vec3.y * 0.015 * (double)loyaltyLevel, entity.getZ());
        if (entity.level().isClientSide) {
            entity.yOld = entity.getY();
        }
        entity.setDeltaMovement(entity.getDeltaMovement().scale(0.95).add(vec3.normalize().scale(0.05 * (double)loyaltyLevel)));
        entity.baseTick();
        if (!entity.onGround() || entity.getDeltaMovement().horizontalDistanceSqr() > (double)1.0E-5f || (entity.tickCount + entity.getId()) % 4 == 0) {
            entity.move(MoverType.SELF, entity.getDeltaMovement());
        }
        if (!entity.level().isClientSide && entity.getDeltaMovement().subtract(vec3).lengthSqr() > 0.01) {
            entity.hasImpulse = true;
        }
    }

    @Nullable
    public static Player isAcceptableReturnOwner(Level level, @Nullable Entity owner) {
        Player player;
        return owner instanceof Player && (player = (Player)owner).isAlive() && !player.isSpectator() ? player : null;
    }
}

