/*
 * Decompiled with CFR 0.152.
 */
package fuzs.bettertridents;

import fuzs.bettertridents.capability.LastDamageSourceCapability;
import fuzs.bettertridents.config.CommonConfig;
import fuzs.bettertridents.config.ServerConfig;
import fuzs.bettertridents.data.DynamicEnchantmentRegistryProvider;
import fuzs.bettertridents.handler.LoyalDropsHandler;
import fuzs.bettertridents.init.ModRegistry;
import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.context.BuildCreativeModeTabContentsContext;
import fuzs.puzzleslib.api.core.v1.context.PackRepositorySourcesContext;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingDeathCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingDropsCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingExperienceDropCallback;
import fuzs.puzzleslib.api.event.v1.server.LootTableLoadEvents;
import fuzs.puzzleslib.api.resources.v1.DynamicPackResources;
import fuzs.puzzleslib.api.resources.v1.PackResourcesHelper;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BetterTridents
implements ModConstructor {
    public static final String MOD_ID = "bettertridents";
    public static final String MOD_NAME = "Better Tridents";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Better Tridents");
    public static final ConfigHolder CONFIG = ConfigHolder.builder((String)"bettertridents").server(ServerConfig.class).common(CommonConfig.class);

    public void onConstructMod() {
        ModRegistry.touch();
        BetterTridents.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        LivingDropsCallback.EVENT.register(LoyalDropsHandler::onLivingDrops);
        LivingExperienceDropCallback.EVENT.register(LoyalDropsHandler::onLivingExperienceDrop);
        LootTableLoadEvents.MODIFY.register((resourceLocation, addLootPool, removeLootPool) -> {
            if (!((CommonConfig)BetterTridents.CONFIG.get(CommonConfig.class)).tridentFragmentDrop) {
                return;
            }
            if (EntityType.ELDER_GUARDIAN.getDefaultLootTable().location().equals((Object)resourceLocation)) {
                addLootPool.accept(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModRegistry.TRIDENT_FRAGMENT_ITEM.value()))).build());
            }
        });
        LivingDeathCallback.EVENT.register(LastDamageSourceCapability::onLivingDeath);
        LivingDropsCallback.EVENT.register(LastDamageSourceCapability::onLivingDrops);
    }

    public void onBuildCreativeModeTabContents(BuildCreativeModeTabContentsContext context) {
        context.registerBuildListener(CreativeModeTabs.INGREDIENTS, (itemDisplayParameters, output) -> output.accept((ItemLike)ModRegistry.TRIDENT_FRAGMENT_ITEM.value()));
    }

    public void onAddDataPackFinders(PackRepositorySourcesContext context) {
        if (!((CommonConfig)BetterTridents.CONFIG.get(CommonConfig.class)).boostImpaling) {
            return;
        }
        context.addRepositorySource(new RepositorySource[]{PackResourcesHelper.buildServerPack((ResourceLocation)BetterTridents.id("boosted_impaling"), (Supplier)DynamicPackResources.create((DataProviderContext.Factory[])new DataProviderContext.Factory[]{DynamicEnchantmentRegistryProvider::new}), (boolean)true)});
    }

    public static ResourceLocation id(String path) {
        return ResourceLocationHelper.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

