/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.neoforge.datagen.provider.advancement;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.critereon.WitnessWeatherTrigger;
import cn.leolezury.eternalstarlight.common.data.ESBiomes;
import cn.leolezury.eternalstarlight.common.data.ESDimensions;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.registry.ESCriteriaTriggers;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESMobEffects;
import cn.leolezury.eternalstarlight.common.registry.ESWeathers;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.EffectsChangedTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.FluidPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.PlayerInteractTrigger;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.advancements.critereon.SummonedEntityTrigger;
import net.minecraft.advancements.critereon.TameAnimalTrigger;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ESAdvancementGenerator
implements AdvancementProvider.AdvancementGenerator {
    public void generate(HolderLookup.Provider registries, Consumer<AdvancementHolder> consumer, ExistingFileHelper helper) {
        HolderLookup.RegistryLookup biomes = registries.lookupOrThrow(Registries.BIOME);
        HolderLookup.RegistryLookup fluids = registries.lookupOrThrow(Registries.FLUID);
        AdvancementHolder root = Advancement.Builder.advancement().display((ItemLike)ESBlocks.LUNAR_LOG.get(), (Component)Component.translatable((String)"advancements.eternal_starlight.root.title"), (Component)Component.translatable((String)"advancements.eternal_starlight.root.description"), EternalStarlight.id("textures/block/lunar_log.png"), AdvancementType.TASK, false, false, false).addCriterion("in_dim", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inDimension(ESDimensions.STARLIGHT_KEY))).save(consumer, "eternal_starlight:root");
        AdvancementHolder challengeGatekeeper = Advancement.Builder.advancement().parent(root).display((ItemLike)Items.DIAMOND_SWORD, (Component)Component.translatable((String)"advancements.eternal_starlight.challenge_gatekeeper.title"), (Component)Component.translatable((String)"advancements.eternal_starlight.challenge_gatekeeper.description"), null, AdvancementType.TASK, true, true, false).addCriterion("challenged", ESCriteriaTriggers.CHALLENGED_GATEKEEPER.get().createCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(Optional.empty()))).save(consumer, "eternal_starlight:challenge_gatekeeper");
        AdvancementHolder obtainOrbOfProphecy = ESAdvancementGenerator.addItemObtain(consumer, challengeGatekeeper, "obtain_orb_of_prophecy", ESItems.ORB_OF_PROPHECY.get());
        AdvancementHolder enterDim = Advancement.Builder.advancement().parent(obtainOrbOfProphecy).display((ItemLike)ESBlocks.LUNAR_LOG.get(), (Component)Component.translatable((String)"advancements.eternal_starlight.enter_starlight.title"), (Component)Component.translatable((String)"advancements.eternal_starlight.enter_starlight.description"), null, AdvancementType.TASK, true, true, false).addCriterion("in_dim", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inDimension(ESDimensions.STARLIGHT_KEY))).save(consumer, "eternal_starlight:enter_starlight");
        AdvancementHolder seekingEye = ESAdvancementGenerator.addItemObtain(consumer, enterDim, "obtain_seeking_eye", ESItems.SEEKING_EYE.get());
        AdvancementHolder enterAbyss = ESAdvancementGenerator.addInBiome(consumer, enterDim, "enter_abyss", ESItems.ABYSSLATE.get(), (Holder<Biome>)biomes.getOrThrow(ESBiomes.THE_ABYSS));
        AdvancementHolder redVelvetumossFlower = ESAdvancementGenerator.addItemObtain(consumer, enterAbyss, "obtain_red_velvetumoss_flower", ESItems.RED_VELVETUMOSS_FLOWER.get());
        AdvancementHolder underPermafrostForest = Advancement.Builder.advancement().parent(enterDim).display((ItemLike)ESBlocks.ICICLE.get(), (Component)Component.translatable((String)"advancements.eternal_starlight.under_permafrost_forest.title"), (Component)Component.translatable((String)"advancements.eternal_starlight.under_permafrost_forest.description"), null, AdvancementType.TASK, true, true, false).addCriterion("in_biome", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)biomes.getOrThrow(ESBiomes.STARLIGHT_PERMAFROST_FOREST)).setY(MinMaxBounds.Doubles.atMost((double)-5.0)))).save(consumer, "eternal_starlight:under_permafrost_forest");
        AdvancementHolder glaciteShard = ESAdvancementGenerator.addItemObtain(consumer, underPermafrostForest, "obtain_glacite_shard", ESItems.GLACITE_SHARD.get());
        AdvancementHolder glaciteArrow = ESAdvancementGenerator.addItemObtain(consumer, glaciteShard, "obtain_glacite_arrow", ESItems.GLACITE_ARROW.get());
        AdvancementHolder frozenBomb = ESAdvancementGenerator.addItemObtain(consumer, underPermafrostForest, "obtain_frozen_bomb", ESItems.FROZEN_BOMB.get());
        AdvancementHolder auroraDeerAntler = ESAdvancementGenerator.addItemObtain(consumer, underPermafrostForest, "obtain_aurora_deer_antler", ESItems.AURORA_DEER_ANTLER.get());
        AdvancementHolder enterCrystallizedDesert = ESAdvancementGenerator.addInBiome(consumer, enterDim, "enter_crystallized_desert", ESItems.BLUE_STARLIGHT_CRYSTAL_SHARD.get(), (Holder<Biome>)biomes.getOrThrow(ESBiomes.CRYSTALLIZED_DESERT));
        AdvancementHolder toothOfHunger = ESAdvancementGenerator.addItemObtain(consumer, enterCrystallizedDesert, "obtain_tooth_of_hunger", ESItems.TOOTH_OF_HUNGER.get());
        AdvancementHolder daggerOfHunger = ESAdvancementGenerator.addItemObtain(consumer, toothOfHunger, "obtain_dagger_of_hunger", ESItems.DAGGER_OF_HUNGER.get());
        AdvancementHolder saturateDaggerOfHunger = Advancement.Builder.advancement().parent(daggerOfHunger).display((ItemLike)ESItems.DAGGER_OF_HUNGER.get(), (Component)Component.translatable((String)"advancements.eternal_starlight.saturate_dagger_of_hunger.title"), (Component)Component.translatable((String)"advancements.eternal_starlight.saturate_dagger_of_hunger.description"), null, AdvancementType.TASK, true, true, false).addCriterion("saturate", ESCriteriaTriggers.SATURATE_DAGGER_OF_HUNGER.get().createCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(Optional.empty()))).save(consumer, "eternal_starlight:saturate_dagger_of_hunger");
        AdvancementHolder toothOfHungerBlocks = ESAdvancementGenerator.addItemObtain(consumer, toothOfHunger, "obtain_tooth_of_hunger_blocks", ESTags.Items.TOOTH_OF_HUNGER_BLOCKS, ESItems.CHISELED_TOOTH_OF_HUNGER_TILES.get());
        AdvancementHolder crystalbornCatalyst = ESAdvancementGenerator.addItemObtain(consumer, toothOfHunger, "obtain_crystalborn_catalyst", ESItems.CRYSTALBORN_CATALYST.get());
        AdvancementHolder summonGrimstoneGolem = ESAdvancementGenerator.addEntitySummon(consumer, enterCrystallizedDesert, "summon_grimstone_golem", ESEntities.GRIMSTONE_GOLEM.get(), ESItems.GRIMSTONE_BRICKS.get());
        AdvancementHolder throwGleechEgg = Advancement.Builder.advancement().parent(enterCrystallizedDesert).display((ItemLike)ESItems.GLEECH_EGG.get(), (Component)Component.translatable((String)"advancements.eternal_starlight.throw_gleech_egg.title"), (Component)Component.translatable((String)"advancements.eternal_starlight.throw_gleech_egg.description"), null, AdvancementType.TASK, true, true, false).addCriterion("thrown", ESCriteriaTriggers.THROW_GLEECH_EGG.get().createCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(Optional.empty()))).save(consumer, "eternal_starlight:throw_gleech_egg");
        AdvancementHolder tameCrystallizedMoth = Advancement.Builder.advancement().parent(enterCrystallizedDesert).display((ItemLike)ESItems.SHIVERING_GEL.get(), (Component)Component.translatable((String)"advancements.eternal_starlight.tame_crystallized_moth.title"), (Component)Component.translatable((String)"advancements.eternal_starlight.tame_crystallized_moth.description"), null, AdvancementType.TASK, true, true, false).addCriterion("tame", TameAnimalTrigger.TriggerInstance.tamedAnimal((EntityPredicate.Builder)EntityPredicate.Builder.entity().of(ESEntities.CRYSTALLIZED_MOTH.get()))).save(consumer, "eternal_starlight:tame_crystallized_moth");
        AdvancementHolder inEtherFluid = ESAdvancementGenerator.addInFluid(consumer, enterDim, "in_ether_fluid", ESItems.ETHER_BUCKET.get(), (HolderSet<Fluid>)fluids.getOrThrow(ESTags.Fluids.ETHER));
        AdvancementHolder thioquartzShard = ESAdvancementGenerator.addItemObtain(consumer, inEtherFluid, "obtain_thioquartz_shard", ESItems.THIOQUARTZ_SHARD.get());
        AdvancementHolder alchemistMask = ESAdvancementGenerator.addItemObtain(consumer, thioquartzShard, "obtain_alchemist_mask", ESItems.ALCHEMIST_MASK.get());
        AdvancementHolder witnessMeteorShower = Advancement.Builder.advancement().parent(enterDim).display((ItemLike)ESItems.RAW_AETHERSENT.get(), (Component)Component.translatable((String)"advancements.eternal_starlight.witness_meteor_shower.title"), (Component)Component.translatable((String)"advancements.eternal_starlight.witness_meteor_shower.description"), null, AdvancementType.TASK, true, true, false).addCriterion("witnessed", ESCriteriaTriggers.WITNESS_WEATHER.get().createCriterion((CriterionTriggerInstance)new WitnessWeatherTrigger.TriggerInstance(Optional.empty(), ESWeathers.METEOR_SHOWER.asHolder()))).save(consumer, "eternal_starlight:witness_meteor_shower");
        AdvancementHolder aethersentIngot = ESAdvancementGenerator.addItemObtain(consumer, witnessMeteorShower, "obtain_aethersent_ingot", ESItems.AETHERSENT_INGOT.get());
        AdvancementHolder summonAethersentGolem = ESAdvancementGenerator.addEntitySummon(consumer, aethersentIngot, "summon_aethersent_golem", ESEntities.AETHERSENT_GOLEM.get(), ESItems.STARFALL_LONGBOW.get());
        AdvancementHolder killCreteor = ESAdvancementGenerator.addEntityKill(consumer, witnessMeteorShower, "kill_creteor", ESEntities.CRETEOR.get(), ESItems.CRETEOR_HIDE.get());
        AdvancementHolder aetherstrikeRocket = ESAdvancementGenerator.addItemObtain(consumer, killCreteor, "obtain_aetherstrike_rocket", ESItems.AETHERSTRIKE_ROCKET.get());
        AdvancementHolder swampSilverIngot = ESAdvancementGenerator.addItemObtain(consumer, enterDim, "obtain_swamp_silver_ingot", ESItems.SWAMP_SILVER_INGOT.get());
        AdvancementHolder numbnessEffect = Advancement.Builder.advancement().parent(swampSilverIngot).display((ItemLike)ESItems.SILVER_PUNGENCY_FRUIT.get(), (Component)Component.translatable((String)"advancements.eternal_starlight.obtain_numbness_effect.title"), (Component)Component.translatable((String)"advancements.eternal_starlight.obtain_numbness_effect.description"), null, AdvancementType.TASK, true, true, false).addCriterion("obtain", EffectsChangedTrigger.TriggerInstance.hasEffects((MobEffectsPredicate.Builder)MobEffectsPredicate.Builder.effects().and(ESMobEffects.NUMBNESS.asHolder()))).save(consumer, "eternal_starlight:obtain_numbness_effect");
        AdvancementHolder igniteTearBomb = Advancement.Builder.advancement().parent(enterDim).display((ItemLike)ESItems.TEAR_BOMB.get(), (Component)Component.translatable((String)"advancements.eternal_starlight.ignite_tear_bomb.title"), (Component)Component.translatable((String)"advancements.eternal_starlight.ignite_tear_bomb.description"), null, AdvancementType.TASK, true, true, false).addCriterion("ignite", ESCriteriaTriggers.IGNITE_TEAR_BOMB.get().createCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(Optional.empty()))).save(consumer, "eternal_starlight:ignite_tear_bomb");
        AdvancementHolder witnessStranghoulHunt = Advancement.Builder.advancement().parent(enterDim).display((ItemLike)ESItems.MALARITE_SWORD.get(), (Component)Component.translatable((String)"advancements.eternal_starlight.witness_stranghoul_hunt.title"), (Component)Component.translatable((String)"advancements.eternal_starlight.witness_stranghoul_hunt.description"), null, AdvancementType.TASK, true, true, false).addCriterion("witness", ESCriteriaTriggers.WITNESS_STRANGHOUL_HUNT.get().createCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(Optional.empty()))).save(consumer, "eternal_starlight:witness_stranghoul_hunt");
        AdvancementHolder hireStranghoul = Advancement.Builder.advancement().parent(witnessStranghoulHunt).display((ItemLike)ESItems.PUNGENCY_STEW.get(), (Component)Component.translatable((String)"advancements.eternal_starlight.hire_stranghoul.title"), (Component)Component.translatable((String)"advancements.eternal_starlight.hire_stranghoul.description"), null, AdvancementType.TASK, true, true, false).addCriterion("hire", ESCriteriaTriggers.HIRE_STRANGHOUL.get().createCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(Optional.empty()))).save(consumer, "eternal_starlight:hire_stranghoul");
        AdvancementHolder thermalSpringstone = ESAdvancementGenerator.addItemObtain(consumer, enterDim, "obtain_thermal_springstone", ESItems.THERMAL_SPRINGSTONE.get());
        AdvancementHolder rawAmaramber = ESAdvancementGenerator.addItemObtain(consumer, enterDim, "obtain_raw_amaramber", ESItems.RAW_AMARAMBER.get());
        AdvancementHolder stellagmite = ESAdvancementGenerator.addItemObtain(consumer, enterDim, "obtain_stellagmite", ESItems.STELLAGMITE.get());
        AdvancementHolder bouldershroomStew = ESAdvancementGenerator.addItemObtain(consumer, enterDim, "obtain_bouldershroom_stew", ESItems.BOULDERSHROOM_STEW.get());
        AdvancementHolder dustedShard = ESAdvancementGenerator.addItemObtain(consumer, enterDim, "obtain_dusted_shard", ESItems.DUSTED_SHARD.get());
        Advancement.Builder allStarlightBiomesBuilder = Advancement.Builder.advancement().parent(enterDim).display((ItemLike)ESBlocks.NIGHTFALL_GRASS_BLOCK.get(), (Component)Component.translatable((String)"advancements.eternal_starlight.all_starlight_biomes.title"), (Component)Component.translatable((String)"advancements.eternal_starlight.all_starlight_biomes.description"), null, AdvancementType.CHALLENGE, true, true, false).requirements(AdvancementRequirements.Strategy.AND).rewards(AdvancementRewards.Builder.experience((int)500));
        List biomeIds = biomes.listElementIds().sorted(ResourceKey::compareTo).toList();
        for (ResourceKey key : biomeIds) {
            if (!key.location().getNamespace().equals("eternal_starlight")) continue;
            allStarlightBiomesBuilder.addCriterion("in_" + key.location().getPath(), PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)biomes.getOrThrow(key))));
        }
        AdvancementHolder allStarlightBiomes = allStarlightBiomesBuilder.save(consumer, "eternal_starlight:all_starlight_biomes");
        AdvancementHolder deactivateEnergyBlock = Advancement.Builder.advancement().parent(seekingEye).display((ItemLike)ESItems.ENERGY_BLOCK.get(), (Component)Component.translatable((String)"advancements.eternal_starlight.deactivate_energy_block.title"), (Component)Component.translatable((String)"advancements.eternal_starlight.deactivate_energy_block.description"), null, AdvancementType.TASK, true, true, false).addCriterion("deactivate", ESCriteriaTriggers.DEACTIVATE_ENERGY_BLOCK.get().createCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(Optional.empty()))).save(consumer, "eternal_starlight:deactivate_energy_block");
        AdvancementHolder killGolem = ESAdvancementGenerator.addEntityKill(consumer, deactivateEnergyBlock, "kill_golem", ESEntities.STARLIGHT_GOLEM.get(), ESItems.CHISELED_GOLEM_STEEL_BLOCK.get());
        AdvancementHolder golemSteelIngot = ESAdvancementGenerator.addItemObtain(consumer, killGolem, "obtain_golem_steel_ingot", ESItems.GOLEM_STEEL_INGOT.get());
        AdvancementHolder igniteLunarMonstrosity = Advancement.Builder.advancement().parent(killGolem).display((ItemLike)ESItems.SALTPETER_MATCHBOX.get(), (Component)Component.translatable((String)"advancements.eternal_starlight.ignite_lunar_monstrosity.title"), (Component)Component.translatable((String)"advancements.eternal_starlight.ignite_lunar_monstrosity.description"), null, AdvancementType.TASK, true, true, false).addCriterion("ignite", PlayerInteractTrigger.TriggerInstance.itemUsedOnEntity((ItemPredicate.Builder)ItemPredicate.Builder.item().of(ESTags.Items.LUNAR_MONSTROSITY_IGNITERS), Optional.of(EntityPredicate.wrap((EntityPredicate)EntityPredicate.Builder.entity().of(ESEntities.LUNAR_MONSTROSITY.get()).build())))).save(consumer, "eternal_starlight:ignite_lunar_monstrosity");
        AdvancementHolder killLunarMonstrosity = ESAdvancementGenerator.addEntityKill(consumer, igniteLunarMonstrosity, "kill_lunar_monstrosity", ESEntities.LUNAR_MONSTROSITY.get(), ESItems.PARASOL_GRASS.get());
        AdvancementHolder chainTangledSkullExplosion = Advancement.Builder.advancement().parent(killLunarMonstrosity).display((ItemLike)ESItems.TANGLED_SKULL.get(), (Component)Component.translatable((String)"advancements.eternal_starlight.chain_tangled_skull_explosion.title"), (Component)Component.translatable((String)"advancements.eternal_starlight.chain_tangled_skull_explosion.description"), null, AdvancementType.CHALLENGE, true, true, false).rewards(AdvancementRewards.Builder.experience((int)60)).addCriterion("explode", ESCriteriaTriggers.CHAIN_TANGLED_SKULL_EXPLOSION.get().createCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(Optional.empty()))).save(consumer, "eternal_starlight:chain_tangled_skull_explosion");
        AdvancementHolder useBlossomOfStars = Advancement.Builder.advancement().parent(enterDim).display((ItemLike)ESItems.BLOSSOM_OF_STARS.get(), (Component)Component.translatable((String)"advancements.eternal_starlight.use_blossom_of_stars.title"), (Component)Component.translatable((String)"advancements.eternal_starlight.use_blossom_of_stars.description"), null, AdvancementType.CHALLENGE, true, true, true).addCriterion("use_item", ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)ESItems.BLOSSOM_OF_STARS.get()))).save(consumer, "eternal_starlight:use_blossom_of_stars");
    }

    private static AdvancementHolder addItemObtain(Consumer<AdvancementHolder> consumer, AdvancementHolder parent, String id, Item item) {
        return Advancement.Builder.advancement().parent(parent).display((ItemLike)item, (Component)Component.translatable((String)("advancements.eternal_starlight." + id + ".title")), (Component)Component.translatable((String)("advancements.eternal_starlight." + id + ".description")), null, AdvancementType.TASK, true, true, false).addCriterion("has_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{item})).save(consumer, "eternal_starlight:" + id);
    }

    private static AdvancementHolder addItemObtain(Consumer<AdvancementHolder> consumer, AdvancementHolder parent, String id, TagKey<Item> tag, Item item) {
        return Advancement.Builder.advancement().parent(parent).display((ItemLike)item, (Component)Component.translatable((String)("advancements.eternal_starlight." + id + ".title")), (Component)Component.translatable((String)("advancements.eternal_starlight." + id + ".description")), null, AdvancementType.TASK, true, true, false).addCriterion("has_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate.Builder[])new ItemPredicate.Builder[]{ItemPredicate.Builder.item().of(tag)})).save(consumer, "eternal_starlight:" + id);
    }

    private static AdvancementHolder addEntityKill(Consumer<AdvancementHolder> consumer, AdvancementHolder parent, String id, EntityType<?> entity, Item item) {
        return ESAdvancementGenerator.addEntityKill(consumer, parent, id, EntityPredicate.Builder.entity().of(entity).build(), item);
    }

    private static AdvancementHolder addEntityKill(Consumer<AdvancementHolder> consumer, AdvancementHolder parent, String id, EntityPredicate predicate, Item item) {
        return Advancement.Builder.advancement().parent(parent).display((ItemLike)item, (Component)Component.translatable((String)("advancements.eternal_starlight." + id + ".title")), (Component)Component.translatable((String)("advancements.eternal_starlight." + id + ".description")), null, AdvancementType.TASK, true, true, false).addCriterion("kill", KilledTrigger.TriggerInstance.playerKilledEntity(Optional.ofNullable(predicate))).save(consumer, "eternal_starlight:" + id);
    }

    private static AdvancementHolder addEntitySummon(Consumer<AdvancementHolder> consumer, AdvancementHolder parent, String id, EntityType<?> entity, Item item) {
        return ESAdvancementGenerator.addEntitySummon(consumer, parent, id, EntityPredicate.Builder.entity().of(entity), item);
    }

    private static AdvancementHolder addEntitySummon(Consumer<AdvancementHolder> consumer, AdvancementHolder parent, String id, EntityPredicate.Builder predicate, Item item) {
        return Advancement.Builder.advancement().parent(parent).display((ItemLike)item, (Component)Component.translatable((String)("advancements.eternal_starlight." + id + ".title")), (Component)Component.translatable((String)("advancements.eternal_starlight." + id + ".description")), null, AdvancementType.TASK, true, true, false).addCriterion("summon", SummonedEntityTrigger.TriggerInstance.summonedEntity((EntityPredicate.Builder)predicate)).save(consumer, "eternal_starlight:" + id);
    }

    private static AdvancementHolder addInBiome(Consumer<AdvancementHolder> consumer, AdvancementHolder parent, String id, Item display, Holder<Biome> biome) {
        return Advancement.Builder.advancement().parent(parent).display((ItemLike)display, (Component)Component.translatable((String)("advancements.eternal_starlight." + id + ".title")), (Component)Component.translatable((String)("advancements.eternal_starlight." + id + ".description")), null, AdvancementType.TASK, true, true, false).addCriterion("in_biome", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome(biome))).save(consumer, "eternal_starlight:" + id);
    }

    private static AdvancementHolder addInFluid(Consumer<AdvancementHolder> consumer, AdvancementHolder parent, String id, Item display, HolderSet<Fluid> fluids) {
        return Advancement.Builder.advancement().parent(parent).display((ItemLike)display, (Component)Component.translatable((String)("advancements.eternal_starlight." + id + ".title")), (Component)Component.translatable((String)("advancements.eternal_starlight." + id + ".description")), null, AdvancementType.TASK, true, true, false).addCriterion("in_fluid", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.location().setFluid(FluidPredicate.Builder.fluid().of(fluids)))).save(consumer, "eternal_starlight:" + id);
    }
}

