/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.feature.coral;

import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BaseCoralWallFanBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public abstract class ESCoralFeature
extends Feature<NoneFeatureConfiguration> {
    public ESCoralFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        RandomSource randomSource = featurePlaceContext.random();
        WorldGenLevel worldGenLevel = featurePlaceContext.level();
        BlockPos blockPos = featurePlaceContext.origin();
        Optional<Block> optional = BuiltInRegistries.BLOCK.getTag(ESTags.Blocks.CORAL_BLOCKS).flatMap(named -> named.getRandomElement(randomSource)).map(Holder::value);
        return optional.filter(block -> this.placeFeature((LevelAccessor)worldGenLevel, randomSource, blockPos, block.defaultBlockState())).isPresent();
    }

    protected abstract boolean placeFeature(LevelAccessor var1, RandomSource var2, BlockPos var3, BlockState var4);

    protected boolean placeCoralBlock(LevelAccessor levelAccessor, RandomSource randomSource, BlockPos blockPos, BlockState state) {
        BlockPos blockPos2 = blockPos.above();
        BlockState blockState2 = levelAccessor.getBlockState(blockPos);
        if ((blockState2.is(Blocks.WATER) || blockState2.is(ESTags.Blocks.CORALS)) && levelAccessor.getBlockState(blockPos2).is(Blocks.WATER)) {
            levelAccessor.setBlock(blockPos, state, 3);
            if (randomSource.nextFloat() < 0.25f) {
                BuiltInRegistries.BLOCK.getTag(ESTags.Blocks.CORALS).flatMap(named -> named.getRandomElement(randomSource)).map(Holder::value).ifPresent(block -> levelAccessor.setBlock(blockPos2, block.defaultBlockState(), 2));
            } else if (randomSource.nextFloat() < 0.05f) {
                levelAccessor.setBlock(blockPos2, ESBlocks.JINGLING_PICKLE.get().defaultBlockState(), 2);
            }
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos blockPos3;
                if (!(randomSource.nextFloat() < 0.2f) || !levelAccessor.getBlockState(blockPos3 = blockPos.relative(direction)).is(Blocks.WATER)) continue;
                BuiltInRegistries.BLOCK.getTag(ESTags.Blocks.WALL_CORALS).flatMap(named -> named.getRandomElement(randomSource)).map(Holder::value).ifPresent(block -> {
                    BlockState blockState = block.defaultBlockState();
                    if (blockState.hasProperty((Property)BaseCoralWallFanBlock.FACING)) {
                        blockState = (BlockState)blockState.setValue((Property)BaseCoralWallFanBlock.FACING, (Comparable)direction);
                    }
                    levelAccessor.setBlock(blockPos3, blockState, 2);
                });
            }
            return true;
        }
        return false;
    }
}

