/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.weather;

import cn.leolezury.eternalstarlight.common.registry.ESWeathers;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.IntProvider;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public abstract class AbstractWeather {
    private final Properties properties;

    public Properties weatherProperties() {
        return this.properties;
    }

    public AbstractWeather(Properties properties) {
        this.properties = properties;
    }

    public abstract boolean canStart(ServerLevel var1);

    public abstract boolean canContinue(ServerLevel var1, int var2);

    public abstract void serverTick(ServerLevel var1, int var2);

    public abstract void tickBlock(ServerLevel var1, int var2, BlockPos var3);

    public abstract void onStart(ServerLevel var1);

    public abstract void onStop(ServerLevel var1, int var2);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void clientTick();

    @OnlyIn(value=Dist.CLIENT)
    public abstract float modifyRainLevel(float var1);

    public String getDescriptionId() {
        return Util.makeDescriptionId((String)"weather", (ResourceLocation)ESWeathers.WEATHERS.registry().getKey((Object)this));
    }

    public Component getDescription() {
        return Component.translatable((String)this.getDescriptionId());
    }

    public record Properties(IntProvider duration, IntProvider interval) {
    }
}

