/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.util;

import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TrailEffect {
    private static final int MAX_CAPACITY = 65536;
    private final ArrayList<TrailPoint> verticalPoints = new ArrayList();
    private final ArrayList<TrailPoint> horizontalPoints = new ArrayList();
    private final ArrayList<TrailPoint> verticalRenderPoints = new ArrayList();
    private final ArrayList<TrailPoint> horizontalRenderPoints = new ArrayList();
    private final float width;
    private float oldLength;
    private float length;

    public ArrayList<TrailPoint> getVerticalRenderPoints() {
        return this.verticalRenderPoints;
    }

    public ArrayList<TrailPoint> getHorizontalRenderPoints() {
        return this.horizontalRenderPoints;
    }

    public float getWidth() {
        return this.width;
    }

    public float getLength() {
        return this.length;
    }

    public void setLength(float length) {
        this.length = length;
    }

    public TrailEffect(float width, int length) {
        this.width = width;
        this.length = length;
    }

    private List<TrailPoint> getPoints(boolean vertical) {
        return vertical ? this.verticalPoints : this.horizontalPoints;
    }

    public void update(TrailPoint point, boolean vertical) {
        if (this.getPoints(vertical).isEmpty() || this.getPoints(vertical).getFirst().center().distanceTo(point.center()) > 0.1) {
            this.getPoints(vertical).addFirst(point);
        }
        if (this.getPoints(vertical).size() > 65536) {
            this.getPoints(vertical).removeLast();
        }
    }

    public void update(Vec3 pos, Vec3 delta) {
        this.oldLength = this.length;
        float yaw = ESMathUtil.positionToYaw(delta);
        float pitch = ESMathUtil.positionToPitch(delta);
        Vec3 upper = ESMathUtil.rotationToPosition(pos, this.width / 2.0f, pitch - 90.0f, yaw);
        Vec3 lower = ESMathUtil.rotationToPosition(pos, this.width / 2.0f, pitch + 90.0f, yaw);
        this.update(new TrailPoint(upper, lower), true);
        Vec3 offset = upper.subtract(lower).cross(delta).normalize().scale((double)(this.width / 2.0f));
        Vec3 upper1 = pos.add(offset);
        Vec3 lower1 = pos.add(offset.scale(-1.0));
        this.update(new TrailPoint(upper1, lower1), false);
    }

    public void prepareRender(Vec3 pos, Vec3 delta, float partialTicks) {
        float yaw = ESMathUtil.positionToYaw(delta);
        float pitch = ESMathUtil.positionToPitch(delta);
        Vec3 upper = ESMathUtil.rotationToPosition(pos, this.width / 2.0f, pitch - 90.0f, yaw);
        Vec3 lower = ESMathUtil.rotationToPosition(pos, this.width / 2.0f, pitch + 90.0f, yaw);
        this.verticalRenderPoints.clear();
        this.verticalRenderPoints.addAll(this.verticalPoints);
        this.prepare(new TrailPoint(upper, lower), true, partialTicks);
        Vec3 offset = upper.subtract(lower).cross(delta).normalize().scale((double)(this.width / 2.0f));
        Vec3 upper1 = pos.add(offset);
        Vec3 lower1 = pos.add(offset.scale(-1.0));
        this.horizontalRenderPoints.clear();
        this.horizontalRenderPoints.addAll(this.horizontalPoints);
        this.prepare(new TrailPoint(upper1, lower1), false, partialTicks);
    }

    private void prepare(TrailPoint point, boolean vertical, float partialTicks) {
        ArrayList<TrailPoint> points = vertical ? this.verticalRenderPoints : this.horizontalRenderPoints;
        ArrayList<TrailPoint> modified = new ArrayList<TrailPoint>();
        points.addFirst(point);
        float totalLength = 0.0f;
        float renderLength = Mth.lerp((float)partialTicks, (float)this.oldLength, (float)this.length);
        for (int i = 0; i < points.size() - 1; ++i) {
            TrailPoint from = points.get(i);
            TrailPoint to = points.get(i + 1);
            float distance = (float)from.center().distanceTo(to.center());
            if (!((totalLength += distance) > renderLength)) continue;
            points.set(i + 1, this.interpolateTrailPoint((totalLength - renderLength) / distance, to, from));
            modified.addAll(points.subList(0, i + 2));
            totalLength = renderLength;
            break;
        }
        if (!modified.isEmpty()) {
            points.clear();
            points.addAll(modified);
        }
        float currentLength = 0.0f;
        for (int i = 0; i < points.size() - 1; ++i) {
            TrailPoint from = points.get(i);
            TrailPoint to = points.get(i + 1);
            float distance = (float)from.center().distanceTo(to.center());
            points.set(i, points.get(i).withWidth((totalLength - currentLength) * (this.width / totalLength)));
            currentLength += distance;
        }
        if (points.size() > 1) {
            points.set(points.size() - 1, points.getLast().withWidth(0.01f));
        }
    }

    private TrailPoint interpolateTrailPoint(float progress, TrailPoint first, TrailPoint second) {
        return new TrailPoint(ESMathUtil.lerpVec(progress, first.upper(), second.upper()), ESMathUtil.lerpVec(progress, first.lower(), second.lower()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(VertexConsumer consumer, PoseStack stack, boolean vertical, float r, float g, float b, float a, int light) {
        ArrayList<TrailPoint> points;
        ArrayList<TrailPoint> arrayList = points = vertical ? this.verticalRenderPoints : this.horizontalRenderPoints;
        if (points.size() >= 2) {
            for (int i = 0; i < points.size() - 1; ++i) {
                TrailPoint from = points.get(i);
                TrailPoint to = points.get(i + 1);
                PoseStack.Pose pose = stack.last();
                consumer.addVertex(pose, (float)from.upper().x, (float)from.upper().y, (float)from.upper().z).setColor(r, g, b, i == 0 ? 0.0f : a).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 0.0f, 1.0f, 0.0f);
                consumer.addVertex(pose, (float)to.upper().x, (float)to.upper().y, (float)to.upper().z).setColor(r, g, b, a).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 0.0f, 1.0f, 0.0f);
                consumer.addVertex(pose, (float)to.lower().x, (float)to.lower().y, (float)to.lower().z).setColor(r, g, b, a).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 0.0f, 1.0f, 0.0f);
                consumer.addVertex(pose, (float)from.lower().x, (float)from.lower().y, (float)from.lower().z).setColor(r, g, b, i == 0 ? 0.0f : a).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 0.0f, 1.0f, 0.0f);
            }
        }
    }

    public record TrailPoint(Vec3 upper, Vec3 lower) {
        public Vec3 center() {
            return this.lower().add(this.upper().subtract(this.lower()).scale(0.5));
        }

        public float width() {
            return (float)this.upper().distanceTo(this.lower());
        }

        public TrailPoint withWidth(float width) {
            Vec3 center = this.center();
            Vec3 upperVec = this.upper().subtract(center);
            Vec3 lowerVec = this.lower().subtract(center);
            return new TrailPoint(center.add(upperVec.normalize().scale((double)(width / 2.0f))), center.add(lowerVec.normalize().scale((double)(width / 2.0f))));
        }
    }
}

