/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.util;

import cn.leolezury.eternalstarlight.common.entity.interfaces.SpellCaster;
import cn.leolezury.eternalstarlight.common.spell.AbstractSpell;
import cn.leolezury.eternalstarlight.common.spell.SpellCooldown;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;

public class ESSpellUtil {
    public static int getCooldownFor(LivingEntity entity, AbstractSpell spell) {
        SpellCaster caster;
        Optional<SpellCooldown> cooldown;
        if (entity instanceof SpellCaster && (cooldown = (caster = (SpellCaster)entity).getESSpellCooldowns().stream().filter(c -> c.getSpell() == spell).findFirst()).isPresent()) {
            return cooldown.get().getCooldown();
        }
        return 0;
    }

    public static void setCooldownFor(LivingEntity entity, AbstractSpell spell, int cooldown) {
        if (entity instanceof SpellCaster) {
            SpellCaster caster = (SpellCaster)entity;
            caster.addESSpellCooldown(spell, cooldown);
        }
    }

    public static void tickSpells(LivingEntity entity) {
        if (entity instanceof SpellCaster) {
            SpellCaster caster = (SpellCaster)entity;
            caster.getESSpellCooldowns().forEach(SpellCooldown::tick);
            caster.getESSpellCooldowns().removeIf(c -> c.getCooldown() <= 0);
            if (caster.getESSpellData().hasSpell()) {
                caster.setESSpellData(caster.getESSpellData().increaseTick());
                AbstractSpell spell = caster.getESSpellData().spell();
                if (!entity.level().isClientSide) {
                    int preparationTicks = spell.spellProperties().preparationTicks();
                    int spellTicks = spell.spellProperties().spellTicks();
                    int useTicks = caster.getESSpellData().castTicks();
                    if (!spell.canContinueToCast(entity, useTicks) || !caster.getESSpellSource().canContinue(entity)) {
                        spell.stop(entity, useTicks - preparationTicks);
                    }
                    if (useTicks <= preparationTicks + spellTicks) {
                        spell.tick(entity, useTicks);
                    } else {
                        spell.stop(entity, useTicks - preparationTicks);
                    }
                }
            }
        }
    }
}

