/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.mixin;

import cn.leolezury.eternalstarlight.common.item.magic.OrbOfProphecyItem;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.util.ESCrestUtil;
import cn.leolezury.eternalstarlight.common.util.ESEntityUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin {
    @Shadow
    public abstract ServerLevel serverLevel();

    @Inject(method={"die(Lnet/minecraft/world/damagesource/DamageSource;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;dropAllDeathLoot(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;)V")})
    private void die(DamageSource damageSource, CallbackInfo ci) {
        Inventory inventory = ((Player)this).getInventory();
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack item = inventory.getItem(i);
            if (!item.is(ESItems.ORB_OF_PROPHECY.get()) || ESCrestUtil.getCrests((Player)this, "owned_crests").crests().isEmpty()) continue;
            CompoundTag tag = ESEntityUtil.getPersistentData((Entity)((Player)this)).getCompound("owned_crests");
            OrbOfProphecyItem.recordCrests(this.serverLevel().registryAccess(), item, tag);
            return;
        }
        ItemStack itemStack = ESItems.ORB_OF_PROPHECY.get().getDefaultInstance();
        if (!ESCrestUtil.getCrests((Player)this, "owned_crests").crests().isEmpty()) {
            CompoundTag tag = ESEntityUtil.getPersistentData((Entity)((Player)this)).getCompound("owned_crests");
            OrbOfProphecyItem.recordCrests(this.serverLevel().registryAccess(), itemStack, tag);
            OrbOfProphecyItem.setTemporary(itemStack);
            if (!inventory.add(itemStack)) {
                ItemEntity itemEntity = new ItemEntity((Level)this.serverLevel(), ((Player)this).getX(), ((Player)this).getY(), ((Player)this).getZ(), itemStack);
                this.serverLevel().addFreshEntity((Entity)itemEntity);
            }
        }
    }
}

