/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.mixin;

import cn.leolezury.eternalstarlight.common.registry.ESAttributes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Projectile.class})
public abstract class ProjectileMixin {
    @Shadow
    @Nullable
    public abstract Entity getOwner();

    @Inject(method={"getMovementToShoot(DDDFF)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="RETURN")}, cancellable=true)
    private void getMovementToShoot(double d, double e, double f, float g, float h, CallbackInfoReturnable<Vec3> cir) {
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if ((Projectile)this instanceof ThrownPotion) {
                AttributeInstance distance;
                double factor = 1.0;
                if (livingEntity.getAttributes().hasAttribute(ESAttributes.THROWN_POTION_DISTANCE.asHolder()) && (distance = livingEntity.getAttribute(ESAttributes.THROWN_POTION_DISTANCE.asHolder())) != null) {
                    factor = distance.getValue();
                }
                cir.setReturnValue((Object)((Vec3)cir.getReturnValue()).scale(factor));
            }
        }
    }
}

