/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.mixin;

import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FarmBlock.class})
public class FarmBlockMixin {
    @Inject(method={"getStateForPlacement(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;"}, at={@At(value="RETURN")}, cancellable=true)
    private void getStateForPlacement(BlockPlaceContext blockPlaceContext, CallbackInfoReturnable<BlockState> cir) {
        if (((FarmBlock)this).defaultBlockState().is((Block)ESBlocks.NIGHTFALL_FARMLAND.get()) && !((FarmBlock)this).defaultBlockState().canSurvive((LevelReader)blockPlaceContext.getLevel(), blockPlaceContext.getClickedPos())) {
            cir.setReturnValue((Object)ESBlocks.NIGHTFALL_DIRT.get().defaultBlockState());
        }
    }

    @Inject(method={"turnToDirt(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void turnToDirt(Entity entity, BlockState blockState, Level level, BlockPos blockPos, CallbackInfo ci) {
        if (blockState.is((Block)ESBlocks.NIGHTFALL_FARMLAND.get()) || blockState.is((Block)ESBlocks.NIGHTFALL_DIRT_PATH.get())) {
            ci.cancel();
            BlockState blockState2 = Block.pushEntitiesUp((BlockState)blockState, (BlockState)ESBlocks.NIGHTFALL_DIRT.get().defaultBlockState(), (LevelAccessor)level, (BlockPos)blockPos);
            level.setBlockAndUpdate(blockPos, blockState2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of((Entity)entity, (BlockState)blockState2));
        }
    }
}

