/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.item.combat;

import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.util.ESConventionalTags;
import com.google.common.base.Suppliers;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public enum ESItemTiers implements Tier
{
    AMARAMBER((TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, 250, 6.0f, 2.0f, 14, () -> Ingredient.of(ESConventionalTags.Items.INGOTS_AMARAMBER)),
    AETHERSENT((TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, 400, 6.0f, 1.0f, 22, () -> Ingredient.of(ESConventionalTags.Items.INGOTS_AETHERSENT)),
    THERMAL_SPRINGSTONE((TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, 400, 6.0f, 2.0f, 10, () -> Ingredient.of(ESConventionalTags.Items.INGOTS_THERMAL_SPRINGSTONE)),
    GLACITE((TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, 500, 6.0f, 2.5f, 10, () -> Ingredient.of(ESConventionalTags.Items.GEMS_GLACITE)),
    SWAMP_SILVER((TagKey<Block>)BlockTags.INCORRECT_FOR_DIAMOND_TOOL, 800, 12.0f, 2.0f, 10, () -> Ingredient.of(ESConventionalTags.Items.INGOTS_SWAMP_SILVER)),
    MALARITE((TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, 400, 6.0f, 2.0f, 10, () -> Ingredient.of(ESConventionalTags.Items.GEMS_MALARITE)),
    PUNGENCY_FRUIT((TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, 600, 6.0f, 2.5f, 12, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ESItems.PUNGENCY_FRUIT.get()})),
    DOOMEDEN((TagKey<Block>)BlockTags.INCORRECT_FOR_DIAMOND_TOOL, 2000, 7.5f, 2.5f, 10, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ESItems.BROKEN_DOOMEDEN_BONE.get()})),
    PETAL((TagKey<Block>)BlockTags.INCORRECT_FOR_DIAMOND_TOOL, 1500, 7.5f, 3.5f, 22, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ESItems.TENACIOUS_PETAL.get()})),
    AURORA_DEER_ANTLER((TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, 400, 6.0f, 1.0f, 22, () -> Ingredient.EMPTY),
    TOOTH_OF_HUNGER((TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, 250, 6.0f, 2.5f, 14, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ESItems.TOOTH_OF_HUNGER.get()}));

    private final TagKey<Block> incorrectBlocksForDrops;
    private final int uses;
    private final float speed;
    private final float damage;
    private final int enchantmentValue;
    private final Supplier<Ingredient> repairIngredient;

    private ESItemTiers(TagKey<Block> incorrect, int uses, float speed, float damage, int enchantmentValue, Supplier<Ingredient> supplier) {
        this.incorrectBlocksForDrops = incorrect;
        this.uses = uses;
        this.speed = speed;
        this.damage = damage;
        this.enchantmentValue = enchantmentValue;
        Objects.requireNonNull(supplier);
        this.repairIngredient = Suppliers.memoize(supplier::get);
    }

    public int getUses() {
        return this.uses;
    }

    public float getSpeed() {
        return this.speed;
    }

    public float getAttackDamageBonus() {
        return this.damage;
    }

    public TagKey<Block> getIncorrectBlocksForDrops() {
        return this.incorrectBlocksForDrops;
    }

    public int getEnchantmentValue() {
        return this.enchantmentValue;
    }

    public Ingredient getRepairIngredient() {
        return this.repairIngredient.get();
    }
}

