/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.handler;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.block.fluid.EtherFluid;
import cn.leolezury.eternalstarlight.common.client.helper.ClientHelper;
import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.crest.Crest;
import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.data.ESDimensions;
import cn.leolezury.eternalstarlight.common.entity.projectile.AethersentMeteor;
import cn.leolezury.eternalstarlight.common.entity.projectile.WiltedPetal;
import cn.leolezury.eternalstarlight.common.item.armor.AethersentArmorItem;
import cn.leolezury.eternalstarlight.common.item.armor.GlaciteArmorItem;
import cn.leolezury.eternalstarlight.common.item.armor.ThermalSpringstoneArmorItem;
import cn.leolezury.eternalstarlight.common.item.component.CurrentCrestComponent;
import cn.leolezury.eternalstarlight.common.item.interfaces.TickableArmor;
import cn.leolezury.eternalstarlight.common.item.misc.ManaCrystalItem;
import cn.leolezury.eternalstarlight.common.network.NoParametersPacket;
import cn.leolezury.eternalstarlight.common.network.UpdateWeatherPacket;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESAttributes;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.registry.ESCriteriaTriggers;
import cn.leolezury.eternalstarlight.common.registry.ESDataComponents;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESMobEffects;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import cn.leolezury.eternalstarlight.common.resource.gatekeeper.TheGatekeeperNameManager;
import cn.leolezury.eternalstarlight.common.spell.ManaType;
import cn.leolezury.eternalstarlight.common.util.ConventionalTags;
import cn.leolezury.eternalstarlight.common.util.ESBlockUtil;
import cn.leolezury.eternalstarlight.common.util.ESBookUtil;
import cn.leolezury.eternalstarlight.common.util.ESCrestUtil;
import cn.leolezury.eternalstarlight.common.util.ESEntityUtil;
import cn.leolezury.eternalstarlight.common.util.ESSpellUtil;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import cn.leolezury.eternalstarlight.common.util.ESWeatherUtil;
import cn.leolezury.eternalstarlight.common.weather.AbstractWeather;
import cn.leolezury.eternalstarlight.common.weather.WeatherInstance;
import cn.leolezury.eternalstarlight.common.weather.Weathers;
import cn.leolezury.eternalstarlight.common.world.gen.biomesource.ESBiomeSource;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.FastColor;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class CommonHandlers {
    public static final String TAG_IN_ETHER = "in_ether";
    public static final String TAG_IN_ETHER_TICKS = "in_ether_ticks";
    public static final String TAG_CLIENT_IN_ETHER_TICKS = "client_in_ether_ticks";
    private static final String TAG_OBTAINED_BLOSSOM_OF_STARS = "obtained_blossom_of_stars";
    public static final String TAG_CRYSTAL_ARROW = "eternal_starlight:crystal";
    public static final String TAG_STARFALL_ARROW = "eternal_starlight:starfall";
    public static final String TAG_WILTED_ARROW = "eternal_starlight:wilted";
    public static final String TAG_IN_ABYSSAL_FIRE_TICKS = "in_abyssal_fire_ticks";
    public static final String TAG_NUMBNESS_DAMAGE = "numbness_damage";
    private static final String TAG_TEARY_TICKS = "teary_ticks";
    private static TheGatekeeperNameManager gatekeeperNames;
    private static Weathers starlightWeathers;
    private static AbstractWeather lastWeather;
    private static int ticksSinceLastUpdate;
    private static final AttributeModifier AMARAMBER_BONUS;

    public static String getGatekeeperName() {
        return gatekeeperNames.getTheGatekeeperName();
    }

    public static Optional<WeatherInstance> getActiveWeather() {
        if (starlightWeathers == null) {
            return Optional.empty();
        }
        return starlightWeathers.getActiveWeather();
    }

    public static void onServerTick(MinecraftServer server) {
        if (++ticksSinceLastUpdate >= 20) {
            for (ServerLevel level : server.getAllLevels()) {
                BiomeSource biomeSource = level.getChunkSource().getGenerator().getBiomeSource();
                if (!(biomeSource instanceof ESBiomeSource)) continue;
                ESBiomeSource source = (ESBiomeSource)biomeSource;
                source.setCacheSize(level.players().size() * 8);
            }
            ticksSinceLastUpdate = 0;
        }
    }

    public static void onLevelLoad(ServerLevel serverLevel) {
        if (serverLevel.dimension() == ESDimensions.STARLIGHT_KEY) {
            starlightWeathers = ESWeatherUtil.getOrCreateWeathers(serverLevel);
        }
    }

    public static void onLevelTick(ServerLevel serverLevel) {
        if (serverLevel.dimension() == ESDimensions.STARLIGHT_KEY && starlightWeathers != null) {
            starlightWeathers.tick();
            long gameTime = serverLevel.getGameTime();
            starlightWeathers.getActiveWeather().ifPresentOrElse(weatherInstance -> {
                if (weatherInstance.getWeather() != lastWeather || gameTime % 200L == 0L) {
                    ESPlatform.INSTANCE.sendToAllClients(serverLevel, new UpdateWeatherPacket(weatherInstance.getWeather()));
                    lastWeather = weatherInstance.getWeather();
                }
                if (gameTime % 80L == 0L) {
                    for (ServerPlayer player : serverLevel.players()) {
                        if (!serverLevel.canSeeSky(BlockPos.containing((Position)player.getEyePosition()))) continue;
                        ESCriteriaTriggers.WITNESS_WEATHER.get().trigger(player);
                    }
                }
            }, () -> {
                if (lastWeather != null || gameTime % 200L == 0L) {
                    ESPlatform.INSTANCE.sendToAllClients(serverLevel, new NoParametersPacket("cancel_weather"));
                    lastWeather = null;
                }
            });
        }
    }

    public static float onModifyLivingHurtDamage(LivingEntity entity, DamageSource source, float amount) {
        float modified = amount;
        if (source.is(DamageTypeTags.IS_FIRE)) {
            MobEffectInstance instance;
            if (entity.hasEffect(ESMobEffects.FLAMMABLE.asHolder()) && (instance = entity.getEffect(ESMobEffects.FLAMMABLE.asHolder())) != null) {
                modified *= (float)(instance.getAmplifier() + 2);
            }
            if (entity.getItemBySlot(EquipmentSlot.HEAD).getItem() instanceof ThermalSpringstoneArmorItem || entity.getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof ThermalSpringstoneArmorItem || entity.getItemBySlot(EquipmentSlot.LEGS).getItem() instanceof ThermalSpringstoneArmorItem || entity.getItemBySlot(EquipmentSlot.FEET).getItem() instanceof ThermalSpringstoneArmorItem) {
                modified /= 2.0f;
            }
        }
        if (entity.hasEffect(ESMobEffects.NUMBNESS.asHolder())) {
            CompoundTag tag = ESEntityUtil.getPersistentData((Entity)entity);
            tag.putFloat(TAG_NUMBNESS_DAMAGE, tag.getFloat(TAG_NUMBNESS_DAMAGE) + modified * 0.75f);
            modified *= 0.25f;
        }
        return modified;
    }

    public static void onPostLivingHurt(LivingEntity entity, DamageSource source, float amount) {
        if (amount > 0.0f) {
            Player player;
            Entity serverLevel;
            Entity entity2;
            LivingEntity attacker;
            LivingEntity livingEntity;
            Entity entity3;
            if ((entity.getItemBySlot(EquipmentSlot.HEAD).getItem() instanceof ThermalSpringstoneArmorItem || entity.getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof ThermalSpringstoneArmorItem || entity.getItemBySlot(EquipmentSlot.LEGS).getItem() instanceof ThermalSpringstoneArmorItem || entity.getItemBySlot(EquipmentSlot.FEET).getItem() instanceof ThermalSpringstoneArmorItem) && (entity3 = source.getDirectEntity()) instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity3;
                livingEntity.setRemainingFireTicks(livingEntity.getRemainingFireTicks() + 200);
            }
            if ((entity3 = source.getDirectEntity()) instanceof LivingEntity && (attacker = (LivingEntity)entity3).getWeaponItem().is(ESTags.Items.THERMAL_SPRINGSTONE_WEAPONS)) {
                entity.setRemainingFireTicks(entity.getRemainingFireTicks() + 200);
            }
            if ((entity.getItemBySlot(EquipmentSlot.HEAD).getItem() instanceof GlaciteArmorItem || entity.getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof GlaciteArmorItem || entity.getItemBySlot(EquipmentSlot.LEGS).getItem() instanceof GlaciteArmorItem || entity.getItemBySlot(EquipmentSlot.FEET).getItem() instanceof GlaciteArmorItem) && (entity3 = source.getDirectEntity()) instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity3;
                livingEntity.setTicksFrozen(Math.min(livingEntity.getTicksFrozen() + 80, 300));
            }
            if ((entity3 = source.getDirectEntity()) instanceof LivingEntity && (attacker = (LivingEntity)entity3).getWeaponItem().is(ESTags.Items.GLACITE_WEAPONS) && entity.canFreeze()) {
                entity.setTicksFrozen(Math.min(entity.getTicksFrozen() + 80, 300));
            }
            if ((entity3 = source.getDirectEntity()) instanceof LivingEntity && (attacker = (LivingEntity)entity3).getWeaponItem().is(ESTags.Items.MALARITE_WEAPONS)) {
                entity.addEffect(new MobEffectInstance(MobEffects.POISON, 60));
            }
            if ((entity3 = source.getDirectEntity()) instanceof LivingEntity && (attacker = (LivingEntity)entity3).getWeaponItem().is(ESTags.Items.PUNGENCY_FRUIT_WEAPONS)) {
                entity.addEffect(new MobEffectInstance(MobEffects.POISON, 80, 1));
                entity.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 120));
            }
            if (entity.getItemBySlot(EquipmentSlot.HEAD).getItem() instanceof AethersentArmorItem && entity.getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof AethersentArmorItem && entity.getItemBySlot(EquipmentSlot.LEGS).getItem() instanceof AethersentArmorItem && entity.getItemBySlot(EquipmentSlot.FEET).getItem() instanceof AethersentArmorItem && (entity2 = source.getEntity()) instanceof LivingEntity && (entity2 = (livingEntity = (LivingEntity)entity2).level()) instanceof ServerLevel) {
                serverLevel = (ServerLevel)entity2;
                Vec3 location = livingEntity.position();
                AethersentMeteor.createMeteorShower((Level)serverLevel, entity, livingEntity, location.x, location.y, location.z, 200.0, true);
            }
            if ((serverLevel = source.getDirectEntity()) instanceof Player && (player = (Player)serverLevel).getRandom().nextInt(15) == 0) {
                Inventory inventory = player.getInventory();
                boolean hasCrystals = false;
                for (int i = 0; i < inventory.getContainerSize(); ++i) {
                    if (!inventory.getItem(i).is(ESTags.Items.MANA_CRYSTALS)) continue;
                    hasCrystals = true;
                }
                if (hasCrystals) {
                    ItemEntity itemEntity = new ItemEntity(player.level(), entity.getX(), entity.getY(), entity.getZ(), ESItems.MANA_CRYSTAL_SHARD.get().getDefaultInstance());
                    player.level().addFreshEntity((Entity)itemEntity);
                }
            }
        }
    }

    public static LivingEntity onLivingChangeTarget(LivingEntity entity, LivingEntity newTarget) {
        CompoundTag persistentData;
        int tearyTicks;
        if (newTarget != null && entity.hasEffect(ESMobEffects.TEARY.asHolder()) && (tearyTicks = (persistentData = ESEntityUtil.getPersistentData((Entity)entity)).getInt(TAG_TEARY_TICKS)) <= ESConfig.INSTANCE.mobMaxTearyTicks) {
            return null;
        }
        return newTarget;
    }

    public static void onEntityTick(Entity entity) {
        Item target;
        Level level = entity.level();
        if (entity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            if (!item.level().isClientSide) {
                if (item.tickCount % 100 == 0 && item.getItem().is(ConventionalTags.Items.MUSIC_DISCS) && !item.getItem().is(ESItems.MUSIC_DISC_SPIRIT.get()) && ESBlockUtil.isEntityInBlock((Entity)item, (Block)ESBlocks.ETHER.get())) {
                    item.setItem(ESItems.MUSIC_DISC_SPIRIT.get().getDefaultInstance());
                    item.addDeltaMovement(new Vec3(0.0, 0.25, 0.0));
                }
            } else if (item.getItem().is(ESTags.Items.MANA_CRYSTALS) || item.getItem().getItem() == ESItems.MANA_CRYSTAL_SHARD.get()) {
                ManaType manaType;
                ClientHelper clientHelper = EternalStarlight.getClientHelper();
                Item item2 = item.getItem().getItem();
                if (item2 instanceof ManaCrystalItem) {
                    ManaCrystalItem crystalItem = (ManaCrystalItem)item2;
                    manaType = crystalItem.getManaType();
                } else {
                    manaType = ManaType.LUNAR;
                }
                clientHelper.spawnManaCrystalItemParticles(manaType, item.position().add(0.0, (double)(item.getBbHeight() / 2.0f), 0.0));
            }
        }
        CompoundTag persistentData = ESEntityUtil.getPersistentData(entity);
        int inAbyssalFireTicks = persistentData.getInt(TAG_IN_ABYSSAL_FIRE_TICKS);
        persistentData.putInt(TAG_IN_ABYSSAL_FIRE_TICKS, Math.max(inAbyssalFireTicks - 1, 0));
        if (!level.isClientSide && entity instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)entity;
            if (persistentData.getBoolean(TAG_WILTED_ARROW) && !arrow.inGround) {
                List affected = level.getEntitiesOfClass(LivingEntity.class, entity.getBoundingBox().inflate(5.0));
                affected.removeIf(e -> arrow.getOwner() == e);
                for (LivingEntity livingEntity : affected) {
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 80));
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.WITHER, entity.isInWater() ? 300 : 160));
                }
                if (arrow.tickCount % 4 == 0) {
                    for (int i = 0; i < 3; ++i) {
                        WiltedPetal wiltedPetal;
                        Entity entity2 = arrow.getOwner();
                        if (entity2 instanceof LivingEntity) {
                            LivingEntity living = (LivingEntity)entity2;
                            wiltedPetal = new WiltedPetal(level, living);
                        } else {
                            wiltedPetal = new WiltedPetal(ESEntities.WILTED_PETAL.get(), level);
                        }
                        WiltedPetal wiltedPetal2 = wiltedPetal;
                        wiltedPetal2.setPos(entity.position());
                        Vec3 movement = new Vec3((double)entity.getRandom().nextFloat() - 0.5, (double)entity.getRandom().nextFloat() - 0.5, (double)entity.getRandom().nextFloat() - 0.5);
                        if (affected.size() > i) {
                            target = (LivingEntity)affected.get(i);
                            movement = target.position().add(0.0, (double)(target.getBbHeight() / 2.0f), 0.0).subtract(entity.position());
                        }
                        wiltedPetal2.shoot(movement.x, movement.y, movement.z, 0.8f, 0.2f);
                        level.addFreshEntity((Entity)wiltedPetal2);
                    }
                }
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.sendParticles((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)FastColor.ARGB32.color((int)96, (int)9437243)), entity.getX(), entity.getY(), entity.getZ(), 6, 2.0, 2.0, 2.0, 0.2);
                }
            }
        }
        if (entity instanceof LivingEntity) {
            int n;
            AttributeInstance attributeInstance;
            LivingEntity livingEntity = (LivingEntity)entity;
            ESSpellUtil.tickSpells(livingEntity);
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (!livingEntity.level().isClientSide) {
                    ESCrestUtil.tickCrests(player);
                }
            }
            List<ItemStack> armors = List.of(livingEntity.getItemBySlot(EquipmentSlot.HEAD), livingEntity.getItemBySlot(EquipmentSlot.CHEST), livingEntity.getItemBySlot(EquipmentSlot.LEGS), livingEntity.getItemBySlot(EquipmentSlot.FEET));
            for (ItemStack itemStack : armors) {
                target = itemStack.getItem();
                if (!(target instanceof TickableArmor)) continue;
                TickableArmor tickableArmor = (TickableArmor)target;
                tickableArmor.tick(livingEntity.level(), livingEntity, itemStack);
            }
            boolean armorChanged = false;
            for (EquipmentSlot slot : List.of(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET)) {
                if (!livingEntity.equipmentHasChanged(livingEntity.getLastArmorItem(slot), livingEntity.getItemBySlot(slot))) continue;
                armorChanged = true;
                break;
            }
            if (armorChanged && (attributeInstance = livingEntity.getAttributes().getInstance(Attributes.ARMOR)) != null) {
                if (livingEntity.getItemBySlot(EquipmentSlot.HEAD).is(ESItems.AMARAMBER_HELMET.get()) && livingEntity.getItemBySlot(EquipmentSlot.CHEST).is(ESItems.AMARAMBER_CHESTPLATE.get()) && livingEntity.getItemBySlot(EquipmentSlot.LEGS).isEmpty() && livingEntity.getItemBySlot(EquipmentSlot.FEET).isEmpty()) {
                    if (!attributeInstance.hasModifier(AMARAMBER_BONUS.id())) {
                        attributeInstance.addPermanentModifier(AMARAMBER_BONUS);
                    }
                } else if (attributeInstance.hasModifier(AMARAMBER_BONUS.id())) {
                    attributeInstance.removeModifier(AMARAMBER_BONUS.id());
                }
            }
            if (livingEntity.tickCount % 20 == 0 && (n = persistentData.getInt("meteor_cooldown")) > 0) {
                persistentData.putInt("meteor_cooldown", n - 1);
            }
            int n2 = persistentData.getInt(TAG_IN_ETHER_TICKS);
            AttributeInstance armorInstance = livingEntity.getAttributes().getInstance(Attributes.ARMOR);
            boolean inEther = persistentData.getBoolean(TAG_IN_ETHER);
            if (!livingEntity.level().isClientSide) {
                int tearyTicks;
                if (livingEntity.hasEffect(ESMobEffects.TEARY.asHolder()) && level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.FALLING_WATER, livingEntity.getX() + (double)livingEntity.getBbWidth() * ((double)livingEntity.getRandom().nextFloat() - 0.5), livingEntity.getEyeY(), livingEntity.getZ() + (double)livingEntity.getBbWidth() * ((double)livingEntity.getRandom().nextFloat() - 0.5), 3, 0.0, 0.0, 0.0, 0.0);
                }
                if (!livingEntity.getType().is(ESTags.EntityTypes.TEARY_IMMUNE) && livingEntity.hasEffect(ESMobEffects.TEARY.asHolder()) && (tearyTicks = persistentData.getInt(TAG_TEARY_TICKS)) <= ESConfig.INSTANCE.mobMaxTearyTicks) {
                    Mob mob;
                    if (livingEntity instanceof Mob && (mob = (Mob)livingEntity).getTarget() != null) {
                        mob.setTarget(null);
                        mob.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
                        mob.getNavigation().stop();
                        mob.setLastHurtByMob(null);
                    }
                    persistentData.putInt(TAG_TEARY_TICKS, tearyTicks + 1);
                }
                if (inEther) {
                    float factor = 0.0f;
                    AttributeInstance resistance = livingEntity.getAttribute(ESAttributes.ETHER_RESISTANCE.asHolder());
                    if (resistance != null) {
                        factor = 1.0f - (float)resistance.getValue();
                    }
                    if (armorInstance != null && armorInstance.getValue() <= 0.0 && entity.hurt(ESDamageTypes.getDamageSource(level, ESDamageTypes.ETHER), 0.3f + 0.6f * factor) && level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        for (int i = 0; i < 5; ++i) {
                            serverLevel.sendParticles((ParticleOptions)ESParticles.STARLIGHT.get(), entity.getX() + (livingEntity.getRandom().nextDouble() - 0.5) * (double)entity.getBbWidth(), entity.getY() + (double)entity.getBbHeight() / 2.0 + (livingEntity.getRandom().nextDouble() - 0.5) * (double)entity.getBbHeight(), entity.getZ() + (livingEntity.getRandom().nextDouble() - 0.5) * (double)entity.getBbWidth(), 20, 0.1, 0.1, 0.1, 0.0);
                        }
                    }
                    if ((armorInstance == null || armorInstance.getValue() > 0.0) && livingEntity.getRandom().nextFloat() <= factor) {
                        persistentData.putInt(TAG_IN_ETHER_TICKS, n2 + 1);
                    }
                }
                if (!inEther && n2 > 0) {
                    persistentData.putInt(TAG_IN_ETHER_TICKS, n2 - 1);
                }
                if (n2 <= 0 && armorInstance != null) {
                    armorInstance.removeModifier(EtherFluid.ARMOR_MODIFIER_ID);
                }
                if (livingEntity.tickCount % 20 == 0 && n2 > 0 && armorInstance != null) {
                    armorInstance.removeModifier(EtherFluid.ARMOR_MODIFIER_ID);
                    armorInstance.addPermanentModifier(EtherFluid.armorModifier((float)(-n2) / 100.0f));
                }
            } else {
                int clientEtherTicks = persistentData.getInt(TAG_CLIENT_IN_ETHER_TICKS);
                if (inEther && clientEtherTicks < 140) {
                    persistentData.putInt(TAG_CLIENT_IN_ETHER_TICKS, clientEtherTicks + 1);
                }
                if (!inEther && clientEtherTicks > 0) {
                    persistentData.putInt(TAG_CLIENT_IN_ETHER_TICKS, clientEtherTicks - 1);
                }
            }
            persistentData.putBoolean(TAG_IN_ETHER, false);
        }
    }

    public static void onBlockBroken(Player player, BlockPos pos, BlockState state) {
        if (state.is(BlockTags.LEAVES) && player.level().dimension() == ESDimensions.STARLIGHT_KEY) {
            float chance;
            float f = player.getName().getString().toLowerCase(Locale.ROOT).contains("nuttar") ? (ESEntityUtil.getPersistentData((Entity)player).getBoolean(TAG_OBTAINED_BLOSSOM_OF_STARS) ? 2.5f : 25.0f) : (chance = 0.0025f);
            if (player.getRandom().nextFloat() < chance / 100.0f) {
                ESEntityUtil.getPersistentData((Entity)player).putBoolean(TAG_OBTAINED_BLOSSOM_OF_STARS, true);
                if (!player.getInventory().add(ESItems.BLOSSOM_OF_STARS.get().getDefaultInstance())) {
                    player.spawnAtLocation((ItemLike)ESItems.BLOSSOM_OF_STARS.get());
                }
            }
        }
    }

    public static void onShieldBlock(LivingEntity blocker, DamageSource source) {
        LivingEntity entity;
        Entity entity2;
        if (blocker.getUseItem().is(ESItems.GLACITE_SHIELD.get()) && (entity2 = source.getDirectEntity()) instanceof LivingEntity && (entity = (LivingEntity)entity2).canFreeze()) {
            entity.setTicksFrozen(Math.min(entity.getTicksFrozen() + 100, 300));
        }
    }

    public static void onArrowHit(Projectile projectile, HitResult result) {
        Level level = projectile.level();
        if (level instanceof ServerLevel) {
            Entity living;
            EntityHitResult entityHitResult;
            Entity entity;
            ServerLevel serverLevel = (ServerLevel)level;
            if (ESEntityUtil.getPersistentData((Entity)projectile).contains(TAG_CRYSTAL_ARROW) && result.getType() == HitResult.Type.ENTITY && result instanceof EntityHitResult && (entity = (entityHitResult = (EntityHitResult)result).getEntity()) instanceof LivingEntity) {
                MobEffectInstance instance;
                living = (LivingEntity)entity;
                int level2 = 0;
                if (living.hasEffect(ESMobEffects.CRYSTALLINE_INFECTION.asHolder()) && (instance = living.getEffect(ESMobEffects.CRYSTALLINE_INFECTION.asHolder())) != null) {
                    level2 += instance.getAmplifier();
                }
                living.addEffect(new MobEffectInstance(ESMobEffects.CRYSTALLINE_INFECTION.asHolder(), 200, level2));
            }
            if (ESEntityUtil.getPersistentData((Entity)projectile).contains(TAG_STARFALL_ARROW) && (living = projectile.getOwner()) instanceof LivingEntity) {
                LivingEntity livingEntity;
                EntityHitResult entityHitResult2;
                Entity entity2;
                LivingEntity owner = (LivingEntity)living;
                Vec3 location = result.getLocation();
                AethersentMeteor.createMeteorShower((Level)serverLevel, owner, result instanceof EntityHitResult && (entity2 = (entityHitResult2 = (EntityHitResult)result).getEntity()) instanceof LivingEntity ? (livingEntity = (LivingEntity)entity2) : null, location.x, location.y, location.z, 200.0, false);
            }
        }
    }

    public static void onPlayerNaturalWake(ServerPlayer serverPlayer, BlockPos pos) {
    }

    public static void onCompleteAdvancement(Player player, AdvancementHolder advancement) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (advancement.id().equals((Object)EternalStarlight.id("enter_starlight"))) {
                ESBookUtil.unlock(serverPlayer, EternalStarlight.id("enter_starlight"));
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static void onC2sNoParamPacket(ServerPlayer player, String id) {
        var2_2 = id;
        var3_3 = -1;
        switch (var2_2.hashCode()) {
            case 1570723308: {
                if (!var2_2.equals("switch_crest")) break;
                var3_3 = 0;
            }
        }
        switch (var3_3) {
            case 0: {
                set = ESCrestUtil.getOwnedCrests((Player)player);
                crests = set.crests();
                mainHand = player.getMainHandItem();
                offHand = player.getOffhandItem();
                component = null;
                nextCrest = null;
                if (mainHand.has(ESDataComponents.CURRENT_CREST.get())) {
                    component = (CurrentCrestComponent)mainHand.get(ESDataComponents.CURRENT_CREST.get());
                    spellItem /* !! */  = mainHand;
                } else if (offHand.has(ESDataComponents.CURRENT_CREST.get())) {
                    component = (CurrentCrestComponent)offHand.get(ESDataComponents.CURRENT_CREST.get());
                    spellItem /* !! */  = offHand;
                } else {
                    spellItem /* !! */  = mainHand.is(ESItems.ORB_OF_PROPHECY.get()) != false ? mainHand : (offHand.is(ESItems.ORB_OF_PROPHECY.get()) != false ? offHand : null);
                }
                if (component == null) ** GOTO lbl33
                for (i = 0; i < crests.size(); ++i) {
                    if (!crests.get(i).crest().is(component.crest()) || i >= crests.size() - 1) continue;
                    for (j = i + 1; j < crests.size(); ++j) {
                        if (!((Crest)crests.get(j).crest().value()).getSpell().isPresent()) continue;
                        nextCrest = crests.get(j).crest();
                        ** GOTO lbl37
                    }
                }
                ** GOTO lbl37
lbl33:
                // 2 sources

                for (Crest.Instance instance : crests) {
                    if (!((Crest)instance.crest().value()).getSpell().isPresent()) continue;
                    nextCrest = instance.crest();
                    break;
                }
lbl37:
                // 4 sources

                if (spellItem /* !! */  == null) break;
                if (nextCrest != null && nextCrest.isBound()) {
                    spellItem /* !! */ .applyComponentsAndValidate(DataComponentPatch.builder().set(ESDataComponents.CURRENT_CREST.get(), (Object)new CurrentCrestComponent(nextCrest)).build());
                    break;
                }
                spellItem /* !! */ .remove(ESDataComponents.CURRENT_CREST.get());
            }
        }
    }

    public static void addReloadListeners(AddReloadListenerStrategy strategy) {
        gatekeeperNames = ESPlatform.INSTANCE.createGatekeeperNameManager();
        strategy.add((PreparableReloadListener)gatekeeperNames);
    }

    static {
        ticksSinceLastUpdate = 0;
        AMARAMBER_BONUS = new AttributeModifier(EternalStarlight.id("armor.amaramber_bonus"), 7.0, AttributeModifier.Operation.ADD_VALUE);
    }

    public static interface AddReloadListenerStrategy {
        public void add(PreparableReloadListener var1);
    }
}

