/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.projectile;

import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.network.SetClientEtherTicksPacket;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.util.ESEntityUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class ThioquartzShard
extends ThrowableProjectile {
    public float oSpin;
    public float spin;

    public ThioquartzShard(EntityType<? extends ThioquartzShard> entityType, Level level) {
        super(entityType, level);
    }

    public ThioquartzShard(Level level, LivingEntity livingEntity) {
        super(ESEntities.THIOQUARTZ_SHARD.get(), livingEntity, level);
    }

    public ThioquartzShard(Level level, double x, double y, double z) {
        super(ESEntities.THIOQUARTZ_SHARD.get(), x, y, z, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        if (this.tickCount > 80) {
            this.discard();
        }
        this.oSpin = this.spin;
        this.spin += 0.18849556f;
    }

    protected void onHitBlock(BlockHitResult hitResult) {
        super.onHitBlock(hitResult);
        switch (hitResult.getDirection().getAxis()) {
            case X: {
                this.setDeltaMovement(this.getDeltaMovement().multiply(-0.5, 1.0, 1.0));
                break;
            }
            case Y: {
                this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, -0.5, 1.0));
                break;
            }
            case Z: {
                this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 1.0, -0.5));
            }
        }
    }

    protected void onHitEntity(EntityHitResult hitResult) {
        Entity entity;
        super.onHitEntity(hitResult);
        if (hitResult.getEntity() != this.getOwner() && hitResult.getEntity().hurt(ESDamageTypes.getIndirectEntityDamageSource(this.level(), ESDamageTypes.ETHER, (Entity)this, this.getOwner()), 4.0f) && (entity = hitResult.getEntity()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.playSound(SoundEvents.GLASS_BREAK);
            CompoundTag persistentData = ESEntityUtil.getPersistentData((Entity)livingEntity);
            int inEtherTicks = persistentData.getInt("in_ether_ticks");
            persistentData.putInt("in_ether_ticks", inEtherTicks + 100);
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                ESPlatform.INSTANCE.sendToClient(serverPlayer, new SetClientEtherTicksPacket(serverPlayer.getId(), Math.min(inEtherTicks + 100, 140)));
            }
        }
        this.discard();
    }
}

