/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.projectile;

import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class AshenSnowball
extends ThrowableItemProjectile {
    public AshenSnowball(EntityType<? extends AshenSnowball> entityType, Level level) {
        super(entityType, level);
    }

    public AshenSnowball(Level level, LivingEntity livingEntity) {
        super(ESEntities.ASHEN_SNOWBALL.get(), livingEntity, level);
    }

    public AshenSnowball(Level level, double x, double y, double z) {
        super(ESEntities.ASHEN_SNOWBALL.get(), x, y, z, level);
    }

    protected void onHit(HitResult hitResult) {
        Level level;
        super.onHit(hitResult);
        if (hitResult.getType() != HitResult.Type.MISS && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItem()), this.getX() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), this.getY() + (double)(this.random.nextFloat() * this.getBbHeight()), this.getZ() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), 5, 0.2, 0.2, 0.2, 0.0);
            serverLevel.sendParticles((ParticleOptions)ESParticles.ASHEN_SNOW.get(), this.getX() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), this.getY() + (double)(this.random.nextFloat() * this.getBbHeight()), this.getZ() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), 5, 0.2, 0.2, 0.2, 0.0);
            for (int i = 0; i <= 5; ++i) {
                serverLevel.sendParticles((ParticleOptions)ESParticles.ORBITAL_ASHEN_SNOW.get(), this.getX() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), this.getY() + (double)((this.random.nextFloat() - 0.5f) * this.getBbHeight() * 8.0f), this.getZ() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), 5, 0.2, 1.5, 0.2, 0.0);
            }
            for (LivingEntity entity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(3.0))) {
                if (this.getOwner() == entity) continue;
                entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60));
            }
            this.discard();
        }
    }

    protected void onHitEntity(EntityHitResult hitResult) {
        float i;
        super.onHitEntity(hitResult);
        Entity entity = hitResult.getEntity();
        float f = i = entity instanceof Blaze ? 5.0f : 1.5f;
        if (entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), i) && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 50));
        }
    }

    @NotNull
    protected Item getDefaultItem() {
        return ESItems.ASHEN_SNOWBALL.get();
    }
}

