/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.monster;

import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.particle.RingExplosionParticleOptions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESCriteriaTriggers;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class TangledSkull
extends Monster {
    private static final String TAG_SHOT = "shot";
    private static final String TAG_SHOT_FROM_MONSTROSITY = "shot_from_monstrosity";
    private static final String TAG_SHOT_MOVEMENT_X = "shot_movement_x";
    private static final String TAG_SHOT_MOVEMENT_Y = "shot_movement_y";
    private static final String TAG_SHOT_MOVEMENT_Z = "shot_movement_z";
    public int skullDeathTime;
    protected static final EntityDataAccessor<Boolean> CHARGING = SynchedEntityData.defineId(TangledSkull.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Boolean> SHOT = SynchedEntityData.defineId(TangledSkull.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Boolean> SHOT_FROM_MONSTROSITY = SynchedEntityData.defineId(TangledSkull.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Vector3f> SHOT_MOVEMENT = SynchedEntityData.defineId(TangledSkull.class, (EntityDataSerializer)EntityDataSerializers.VECTOR3);

    public boolean isCharging() {
        return (Boolean)this.getEntityData().get(CHARGING);
    }

    public void setCharging(boolean charging) {
        this.getEntityData().set(CHARGING, (Object)charging);
    }

    public boolean isShot() {
        return (Boolean)this.getEntityData().get(SHOT);
    }

    public void setShot(boolean shot) {
        this.getEntityData().set(SHOT, (Object)shot);
    }

    public boolean isShotFromMonstrosity() {
        return (Boolean)this.getEntityData().get(SHOT_FROM_MONSTROSITY);
    }

    public void setShotFromMonstrosity(boolean shotFromMonstrosity) {
        this.getEntityData().set(SHOT_FROM_MONSTROSITY, (Object)shotFromMonstrosity);
    }

    public Vec3 getShotMovement() {
        return new Vec3((Vector3f)this.getEntityData().get(SHOT_MOVEMENT));
    }

    public void setShotMovement(Vec3 shotMovement) {
        this.getEntityData().set(SHOT_MOVEMENT, (Object)shotMovement.toVector3f());
    }

    public TangledSkull(EntityType<? extends TangledSkull> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new TangledSkullMoveControl(this);
    }

    protected BodyRotationControl createBodyControl() {
        return new TangledSkullRotationControl(this);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new TangledSkullChargeAttackGoal());
        this.goalSelector.addGoal(2, (Goal)new TangledSkullRandomMoveGoal());
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, ESConfig.INSTANCE.mobsConfig.tangledSkull.maxHealth()).add(Attributes.ARMOR, ESConfig.INSTANCE.mobsConfig.tangledSkull.armor()).add(Attributes.ATTACK_DAMAGE, ESConfig.INSTANCE.mobsConfig.tangledSkull.attackDamage()).add(Attributes.FOLLOW_RANGE, ESConfig.INSTANCE.mobsConfig.tangledSkull.followRange());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CHARGING, (Object)false).define(SHOT, (Object)false).define(SHOT_FROM_MONSTROSITY, (Object)false).define(SHOT_MOVEMENT, (Object)Vec3.ZERO.toVector3f());
    }

    public void tick() {
        this.noPhysics = true;
        super.tick();
        this.noPhysics = false;
        this.setNoGravity(true);
        if (!this.level().isClientSide) {
            if (this.isShotFromMonstrosity() && this.tickCount == 30) {
                this.playSound(ESSoundEvents.TANGLED_SKULL_MOAN.get(), 5.0f, 1.0f);
            }
            if (this.isShot()) {
                boolean ally;
                LivingEntity living;
                Entity entity2;
                this.setDeltaMovement(this.getShotMovement());
                HitResult result = ProjectileUtil.getHitResultOnMoveVector((Entity)this, entity -> true);
                if (this.isShotFromMonstrosity() && result.getType() == HitResult.Type.ENTITY && (entity2 = ((EntityHitResult)result).getEntity()) instanceof LivingEntity && !(living = (LivingEntity)entity2).getType().is(ESTags.EntityTypes.LUNAR_MONSTROSITY_ALLYS)) {
                    living.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 60));
                    living.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 60));
                    living.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60));
                    living.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 60));
                }
                boolean bl = ally = this.isShotFromMonstrosity() && result.getType() == HitResult.Type.ENTITY && ((EntityHitResult)result).getEntity().getType().is(ESTags.EntityTypes.LUNAR_MONSTROSITY_ALLYS);
                if (result.getType() != HitResult.Type.MISS && !ally) {
                    Level level;
                    this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 2.0f, Level.ExplosionInteraction.NONE);
                    if (this.isShotFromMonstrosity() && (level = this.level()) instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket(RingExplosionParticleOptions.SOUL, this.getX(), this.getY(), this.getZ(), 0.0, 0.2, 0.0));
                    }
                    this.discard();
                }
            }
        } else {
            this.level().addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, this.getX(), this.getY(0.5), this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    protected void tickDeath() {
        this.setDeltaMovement(Vec3.ZERO);
        ++this.skullDeathTime;
        if (this.skullDeathTime >= 80 && !this.level().isClientSide() && !this.isRemoved()) {
            this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 2.0f, Level.ExplosionInteraction.NONE);
            this.level().broadcastEntityEvent((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public void die(DamageSource source) {
        TangledSkull killer;
        Entity entity;
        super.die(source);
        if (!this.level().isClientSide() && (entity = source.getEntity()) instanceof TangledSkull && (entity = (killer = (TangledSkull)entity).getKillCredit()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ESCriteriaTriggers.CHAIN_TANGLED_SKULL_EXPLOSION.get().trigger(player);
        }
    }

    @Nullable
    public LivingEntity getTarget() {
        return this.isShot() ? null : super.getTarget();
    }

    public void setDeltaMovement(Vec3 vec3) {
        if (this.isShot()) {
            super.setDeltaMovement(this.isShotFromMonstrosity() && this.tickCount < 30 ? Vec3.ZERO : this.getShotMovement());
        } else {
            super.setDeltaMovement(vec3);
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isShot() && !source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public boolean isAlliedTo(Entity entity) {
        return super.isAlliedTo(entity) || entity.getType().is(ESTags.EntityTypes.LUNAR_MONSTROSITY_ALLYS);
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.putBoolean(TAG_SHOT, this.isShot());
        compoundTag.putBoolean(TAG_SHOT_FROM_MONSTROSITY, this.isShotFromMonstrosity());
        if (this.isShot()) {
            compoundTag.putDouble(TAG_SHOT_MOVEMENT_X, this.getShotMovement().x);
            compoundTag.putDouble(TAG_SHOT_MOVEMENT_Y, this.getShotMovement().y);
            compoundTag.putDouble(TAG_SHOT_MOVEMENT_Z, this.getShotMovement().z);
        }
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        if (compoundTag.contains(TAG_SHOT, 1)) {
            this.setShot(compoundTag.getBoolean(TAG_SHOT));
        }
        if (compoundTag.contains(TAG_SHOT_FROM_MONSTROSITY, 1)) {
            this.setShotFromMonstrosity(compoundTag.getBoolean(TAG_SHOT_FROM_MONSTROSITY));
        }
        if (compoundTag.contains(TAG_SHOT_MOVEMENT_X, 6) && compoundTag.contains(TAG_SHOT_MOVEMENT_Y, 6) && compoundTag.contains(TAG_SHOT_MOVEMENT_Z, 6)) {
            this.setShotMovement(new Vec3(compoundTag.getDouble(TAG_SHOT_MOVEMENT_X), compoundTag.getDouble(TAG_SHOT_MOVEMENT_Y), compoundTag.getDouble(TAG_SHOT_MOVEMENT_Z)));
        }
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return ESSoundEvents.TANGLED_SKULL_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.SKELETON_HURT;
    }

    private class TangledSkullMoveControl
    extends MoveControl {
        public TangledSkullMoveControl(TangledSkull skull) {
            super((Mob)skull);
        }

        public void tick() {
            if (this.operation == MoveControl.Operation.MOVE_TO) {
                Vec3 vec3 = new Vec3(this.wantedX - TangledSkull.this.getX(), this.wantedY - TangledSkull.this.getY(), this.wantedZ - TangledSkull.this.getZ());
                double d = vec3.length();
                if (d < TangledSkull.this.getBoundingBox().getSize()) {
                    this.operation = MoveControl.Operation.WAIT;
                    TangledSkull.this.setDeltaMovement(TangledSkull.this.getDeltaMovement().scale(0.5));
                } else {
                    TangledSkull.this.setDeltaMovement(TangledSkull.this.getDeltaMovement().add(vec3.scale(this.speedModifier * 0.05 / d)));
                    if (TangledSkull.this.getTarget() == null) {
                        Vec3 vec32 = TangledSkull.this.getDeltaMovement();
                        TangledSkull.this.setYRot(-((float)Mth.atan2((double)vec32.x, (double)vec32.z)) * 57.295776f);
                    } else {
                        double e = TangledSkull.this.getTarget().getX() - TangledSkull.this.getX();
                        double f = TangledSkull.this.getTarget().getZ() - TangledSkull.this.getZ();
                        TangledSkull.this.setYRot(-((float)Mth.atan2((double)e, (double)f)) * 57.295776f);
                    }
                    TangledSkull.this.yBodyRot = TangledSkull.this.getYRot();
                }
            }
        }
    }

    private class TangledSkullRotationControl
    extends BodyRotationControl {
        public TangledSkullRotationControl(TangledSkull skull) {
            super((Mob)skull);
        }

        public void clientTick() {
            if (TangledSkull.this.isShot()) {
                Vec3 movement = TangledSkull.this.getShotMovement();
                float pitch = ESMathUtil.positionToPitch(movement);
                float yaw = ESMathUtil.positionToYaw(movement);
                TangledSkull.this.setYRot(yaw - 90.0f);
                TangledSkull.this.yHeadRot = yaw - 90.0f;
                TangledSkull.this.yBodyRot = yaw - 90.0f;
                TangledSkull.this.setXRot(-pitch);
            } else {
                super.clientTick();
            }
        }
    }

    private class TangledSkullChargeAttackGoal
    extends Goal {
        public TangledSkullChargeAttackGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            LivingEntity livingEntity = TangledSkull.this.getTarget();
            if (livingEntity != null && livingEntity.isAlive() && !TangledSkull.this.getMoveControl().hasWanted() && TangledSkull.this.random.nextInt(TangledSkullChargeAttackGoal.reducedTickDelay((int)7)) == 0) {
                return TangledSkull.this.distanceToSqr((Entity)livingEntity) > 4.0;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return TangledSkull.this.getMoveControl().hasWanted() && TangledSkull.this.isCharging() && TangledSkull.this.getTarget() != null && TangledSkull.this.getTarget().isAlive();
        }

        public void start() {
            LivingEntity livingEntity = TangledSkull.this.getTarget();
            if (livingEntity != null) {
                Vec3 vec3 = livingEntity.getEyePosition();
                TangledSkull.this.moveControl.setWantedPosition(vec3.x, vec3.y, vec3.z, 1.0);
            }
            TangledSkull.this.setCharging(true);
        }

        public void stop() {
            TangledSkull.this.setCharging(false);
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            LivingEntity livingEntity = TangledSkull.this.getTarget();
            if (livingEntity != null) {
                if (TangledSkull.this.getBoundingBox().intersects(livingEntity.getBoundingBox())) {
                    TangledSkull.this.doHurtTarget((Entity)livingEntity);
                    TangledSkull.this.setCharging(false);
                } else {
                    double d = TangledSkull.this.distanceToSqr((Entity)livingEntity);
                    if (d < 9.0) {
                        Vec3 vec3 = livingEntity.getEyePosition();
                        TangledSkull.this.moveControl.setWantedPosition(vec3.x, vec3.y, vec3.z, 1.0);
                    }
                }
            }
        }
    }

    private class TangledSkullRandomMoveGoal
    extends Goal {
        public TangledSkullRandomMoveGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return !TangledSkull.this.getMoveControl().hasWanted() && TangledSkull.this.random.nextInt(TangledSkullRandomMoveGoal.reducedTickDelay((int)7)) == 0;
        }

        public boolean canContinueToUse() {
            return false;
        }

        public void tick() {
            BlockPos blockPos = TangledSkull.this.blockPosition();
            for (int i = 0; i < 3; ++i) {
                BlockPos blockPos2 = blockPos.offset(TangledSkull.this.random.nextInt(15) - 7, TangledSkull.this.random.nextInt(11) - 5, TangledSkull.this.random.nextInt(15) - 7);
                if (!TangledSkull.this.level().isEmptyBlock(blockPos2)) continue;
                TangledSkull.this.moveControl.setWantedPosition((double)blockPos2.getX() + 0.5, (double)blockPos2.getY() + 0.5, (double)blockPos2.getZ() + 0.5, 0.25);
                if (TangledSkull.this.getTarget() != null) break;
                TangledSkull.this.getLookControl().setLookAt((double)blockPos2.getX() + 0.5, (double)blockPos2.getY() + 0.5, (double)blockPos2.getZ() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }
}

