/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.goal;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RandomFlyGoal
extends Goal {
    private final PathfinderMob mob;

    public RandomFlyGoal(PathfinderMob mob) {
        this.mob = mob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        return this.mob.getNavigation().isDone() && this.mob.getRandom().nextInt(5) == 0;
    }

    public boolean canContinueToUse() {
        return this.mob.getNavigation().isInProgress() && this.mob.getRandom().nextInt(30) != 0;
    }

    public void start() {
        Vec3 target = this.getRandomPos();
        this.mob.getNavigation().moveTo(target.x, target.y, target.z, 1.0);
    }

    private Vec3 getRandomPos() {
        Vec3 target = this.mob.position().add((double)((this.mob.getRandom().nextFloat() - 0.5f) * 2.0f * 15.0f), 0.0, (double)((this.mob.getRandom().nextFloat() - 0.5f) * 2.0f * 15.0f));
        BlockPos position = this.mob.blockPosition();
        int blockY = position.getY();
        if (!this.mob.level().getBlockState(position).isAir()) {
            i = position.getY();
            while (!this.mob.level().getBlockState(new BlockPos(position.getX(), i, position.getZ())).isAir() && i <= this.mob.level().getMaxBuildHeight()) {
                blockY = i++;
            }
        } else {
            for (i = position.getY(); this.mob.level().getBlockState(new BlockPos(position.getX(), i, position.getZ())).isAir() && i >= this.mob.level().getMinBuildHeight(); --i) {
                blockY = i + 1;
            }
        }
        target = new Vec3(target.x, (double)(blockY + 5 + this.mob.getRandom().nextInt(3)), target.z);
        BlockHitResult result = this.mob.level().clip(new ClipContext(this.mob.position(), target, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)this.mob));
        if (result.getType() != HitResult.Type.MISS) {
            target = result.getLocation();
        }
        return target;
    }
}

