/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.goal;

import cn.leolezury.eternalstarlight.common.entity.living.npc.boarwarf.Boarwarf;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;

public class BoarwarfMoveToBedGoal
extends MoveToBlockGoal {
    private final PathfinderMob creature;

    public BoarwarfMoveToBedGoal(PathfinderMob creature, double speedIn, int length) {
        super(creature, speedIn, length);
        this.creature = creature;
    }

    public boolean canUse() {
        PathfinderMob pathfinderMob = this.mob;
        if (pathfinderMob instanceof Boarwarf) {
            Boarwarf boarwarf = (Boarwarf)pathfinderMob;
            return boarwarf.wantsToSleep() && !this.creature.isSleeping() && super.canUse();
        }
        return false;
    }

    public void tick() {
        super.tick();
        if (this.isReachedTarget()) {
            this.creature.startSleeping(this.blockPos);
        }
    }

    protected boolean isValidTarget(LevelReader worldIn, BlockPos pos) {
        BlockState blockstate = worldIn.getBlockState(pos);
        return blockstate.is(BlockTags.BEDS) && blockstate.hasProperty((Property)BedBlock.OCCUPIED) && (Boolean)blockstate.getValue((Property)BedBlock.OCCUPIED) == false && blockstate.hasProperty((Property)BedBlock.PART) && blockstate.getValue((Property)BedBlock.PART) == BedPart.HEAD;
    }

    protected boolean findNearestBlock() {
        PathfinderMob pathfinderMob = this.mob;
        if (pathfinderMob instanceof Boarwarf) {
            Boarwarf boarwarf = (Boarwarf)pathfinderMob;
            int searchRange = 10;
            int verticalSearchRange = 5;
            BlockPos blockpos = boarwarf.homePos;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            int k = this.verticalSearchStart;
            while (k <= verticalSearchRange) {
                for (int l = 0; l < searchRange; ++l) {
                    int i1 = 0;
                    while (i1 <= l) {
                        int j1;
                        int n = j1 = i1 < l && i1 > -l ? l : 0;
                        while (j1 <= l) {
                            blockpos$mutableblockpos.setWithOffset((Vec3i)blockpos, i1, k - 1, j1);
                            if (this.mob.isWithinRestriction((BlockPos)blockpos$mutableblockpos) && this.isValidTarget((LevelReader)this.mob.level(), (BlockPos)blockpos$mutableblockpos)) {
                                this.blockPos = blockpos$mutableblockpos;
                                return true;
                            }
                            j1 = j1 > 0 ? -j1 : 1 - j1;
                        }
                        i1 = i1 > 0 ? -i1 : 1 - i1;
                    }
                }
                k = k > 0 ? -k : 1 - k;
            }
        }
        return false;
    }

    public double acceptedDistance() {
        return 2.0;
    }
}

