/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper;

import cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper.TheGatekeeper;
import cn.leolezury.eternalstarlight.common.entity.living.phase.BehaviorPhase;
import cn.leolezury.eternalstarlight.common.entity.misc.ESFallingBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;

public class GatekeeperDanceFightPhase
extends BehaviorPhase<TheGatekeeper> {
    public static final int ID = 5;

    public GatekeeperDanceFightPhase() {
        super(5, 1, 110, 200);
    }

    @Override
    public boolean canStart(TheGatekeeper entity, boolean cooldownOver) {
        return cooldownOver && this.canReachTarget(entity, 3.0);
    }

    @Override
    public void onStart(TheGatekeeper entity) {
    }

    @Override
    public void tick(TheGatekeeper entity) {
        if (entity.getBehaviorTicks() >= 30 && entity.getBehaviorTicks() <= 50) {
            this.performMeleeAttack(entity, 2.0);
        }
        if (entity.getBehaviorTicks() == 73) {
            this.performMeleeAttack(entity, 5.0);
            for (int x = -5; x <= 5; ++x) {
                for (int y = -2; y <= 2; ++y) {
                    for (int z = -5; z <= 5; ++z) {
                        BlockPos pos = entity.blockPosition().offset(x, y, z);
                        if (!entity.level().getBlockState(pos.above()).isAir() || !(pos.getCenter().distanceTo(entity.position()) <= 5.0)) continue;
                        ESFallingBlock fallingBlock = new ESFallingBlock(entity.level(), (float)pos.getX() + 0.5f, (float)pos.getY() + 0.5f, (float)pos.getZ() + 0.5f, entity.level().getBlockState(pos), 100, false);
                        fallingBlock.push(0.0, entity.getRandom().nextDouble() / 6.0 + 0.25, 0.0);
                        entity.level().addFreshEntity((Entity)fallingBlock);
                    }
                }
            }
        }
    }

    @Override
    public boolean canContinue(TheGatekeeper entity) {
        return true;
    }

    @Override
    public void onStop(TheGatekeeper entity) {
    }
}

