/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.handler.ClientHandlers;
import cn.leolezury.eternalstarlight.common.client.model.entity.StarlightGolemModel;
import cn.leolezury.eternalstarlight.common.client.renderer.layer.StarlightGolemEyesLayer;
import cn.leolezury.eternalstarlight.common.client.renderer.layer.StarlightGolemGlowLayer;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.StarlightGolem;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StarlightGolemRenderer<T extends StarlightGolem>
extends MobRenderer<T, StarlightGolemModel<T>> {
    private static final ResourceLocation ENTITY_TEXTURE = EternalStarlight.id("textures/entity/starlight_golem/starlight_golem.png");
    private static final ResourceLocation HALLOWEEN_TEXTURE = EternalStarlight.id("textures/entity/starlight_golem/starlight_golem_halloween.png");

    public StarlightGolemRenderer(EntityRendererProvider.Context context) {
        super(context, new StarlightGolemModel(context.bakeLayer(StarlightGolemModel.LAYER_LOCATION)), 0.5f);
        this.addLayer(new StarlightGolemGlowLayer(this, context.getModelSet()));
        this.addLayer((RenderLayer)new StarlightGolemEyesLayer(this));
    }

    protected float getFlipDegrees(T entity) {
        return 0.0f;
    }

    public ResourceLocation getTextureLocation(T entity) {
        return ClientHandlers.isHalloween ? HALLOWEEN_TEXTURE : ENTITY_TEXTURE;
    }
}

