/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.entity;

import cn.leolezury.eternalstarlight.common.entity.misc.ESFallingBlock;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ESFallingBlockRenderer
extends EntityRenderer<ESFallingBlock> {
    private final BlockRenderDispatcher dispatcher;

    public ESFallingBlockRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.dispatcher = context.getBlockRenderDispatcher();
    }

    public void render(ESFallingBlock block, float yaw, float delta, PoseStack stack, MultiBufferSource bufferSource, int packedLight) {
        Level level;
        BlockState blockstate = block.getBlockState();
        if (blockstate == null) {
            return;
        }
        if (blockstate.getRenderShape() == RenderShape.MODEL && blockstate != (level = block.level()).getBlockState(block.blockPosition()) && blockstate.getRenderShape() != RenderShape.INVISIBLE) {
            stack.pushPose();
            BlockPos blockpos = BlockPos.containing((double)block.getX(), (double)block.getBoundingBox().maxY, (double)block.getZ());
            stack.translate(-0.5, 0.0, -0.5);
            ESPlatform.INSTANCE.renderBlock(this.dispatcher, stack, bufferSource, level, blockstate, blockpos, blockstate.getSeed(block.getStartPos()));
            stack.popPose();
            super.render((Entity)block, yaw, delta, stack, bufferSource, packedLight);
        }
    }

    public ResourceLocation getTextureLocation(ESFallingBlock block) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

