/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.model.item.CrescentSpearModel;
import cn.leolezury.eternalstarlight.common.client.model.item.GlaciteShieldModel;
import cn.leolezury.eternalstarlight.common.client.model.item.MalariteSpearModel;
import cn.leolezury.eternalstarlight.common.client.model.item.PungencyFruitSpearModel;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ESItemStackRenderer {
    private static GlaciteShieldModel GLACITE_SHIELD_MODEL;
    private static MalariteSpearModel MALARITE_SPEAR_MODEL;
    private static PungencyFruitSpearModel PUNGENCY_FRUIT_SPEAR_MODEL;
    private static CrescentSpearModel CRESCENT_SPEAR_MODEL;

    public static void render(ItemStack stack, ItemDisplayContext context, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, int overlay) {
        VertexConsumer vertexConsumer;
        if (stack.is(ESItems.GLACITE_SHIELD.get())) {
            if (GLACITE_SHIELD_MODEL == null) {
                GLACITE_SHIELD_MODEL = new GlaciteShieldModel(Minecraft.getInstance().getEntityModels().bakeLayer(GlaciteShieldModel.LAYER_LOCATION));
            }
            poseStack.pushPose();
            poseStack.scale(1.0f, -1.0f, -1.0f);
            Material material = new Material(Sheets.SHIELD_SHEET, EternalStarlight.id("entity/glacite_shield"));
            VertexConsumer vertexConsumer2 = material.sprite().wrap(ItemRenderer.getFoilBufferDirect((MultiBufferSource)multiBufferSource, (RenderType)GLACITE_SHIELD_MODEL.renderType(material.atlasLocation()), (boolean)true, (boolean)stack.hasFoil()));
            GLACITE_SHIELD_MODEL.renderToBuffer(poseStack, vertexConsumer2, light, overlay);
            poseStack.popPose();
        }
        if (stack.is(ESItems.MALARITE_SPEAR.get())) {
            if (MALARITE_SPEAR_MODEL == null) {
                MALARITE_SPEAR_MODEL = new MalariteSpearModel(Minecraft.getInstance().getEntityModels().bakeLayer(MalariteSpearModel.LAYER_LOCATION));
            }
            poseStack.pushPose();
            poseStack.scale(1.0f, -1.0f, -1.0f);
            vertexConsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)multiBufferSource, (RenderType)MALARITE_SPEAR_MODEL.renderType(MalariteSpearModel.TEXTURE), (boolean)false, (boolean)stack.hasFoil());
            MALARITE_SPEAR_MODEL.renderToBuffer(poseStack, vertexConsumer, light, overlay);
            poseStack.popPose();
        }
        if (stack.is(ESItems.PUNGENCY_FRUIT_SPEAR.get())) {
            if (PUNGENCY_FRUIT_SPEAR_MODEL == null) {
                PUNGENCY_FRUIT_SPEAR_MODEL = new PungencyFruitSpearModel(Minecraft.getInstance().getEntityModels().bakeLayer(PungencyFruitSpearModel.LAYER_LOCATION));
            }
            poseStack.pushPose();
            poseStack.scale(1.0f, -1.0f, -1.0f);
            vertexConsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)multiBufferSource, (RenderType)PUNGENCY_FRUIT_SPEAR_MODEL.renderType(PungencyFruitSpearModel.TEXTURE), (boolean)false, (boolean)stack.hasFoil());
            PUNGENCY_FRUIT_SPEAR_MODEL.renderToBuffer(poseStack, vertexConsumer, light, overlay);
            poseStack.popPose();
        }
        if (stack.is(ESItems.CRESCENT_SPEAR.get())) {
            if (CRESCENT_SPEAR_MODEL == null) {
                CRESCENT_SPEAR_MODEL = new CrescentSpearModel(Minecraft.getInstance().getEntityModels().bakeLayer(CrescentSpearModel.LAYER_LOCATION));
            }
            poseStack.pushPose();
            poseStack.scale(1.0f, -1.0f, -1.0f);
            vertexConsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)multiBufferSource, (RenderType)CRESCENT_SPEAR_MODEL.renderType(CrescentSpearModel.TEXTURE), (boolean)false, (boolean)stack.hasFoil());
            CRESCENT_SPEAR_MODEL.renderToBuffer(poseStack, vertexConsumer, light, overlay);
            poseStack.popPose();
        }
    }
}

